package freenet.client.cli;
import freenet.client.RequestProcess;
import freenet.client.ComputeCHKProcess;
import freenet.support.Bucket;
import freenet.config.Params;

public class ComputeCHKCommand implements ClientCommand {

    public ComputeCHKCommand() {
    }

    public String getName() {
        return "computechk";
    }

    public String getUsage() {
        return "computechk";
    }

    public String[] getDescription() {
        return new String[] {
            "Computes the CHK value that the given data would have if inserted."
        };
    }

    public int argCount() {
        return 0;
    }

    public RequestProcess getProcess(Params p, Bucket metadata, Bucket data) {
        return new ComputeCHKProcess(p.getString("cipher"), metadata,
                                     data);
    }

    public boolean takesData() {
        return true;
    }

    public boolean givesData() {
        return false;
    }
}
