package freenet.client.cli;
import freenet.config.Params;
import freenet.support.Bucket;
import freenet.support.FileBucketFactory;
import freenet.client.RequestProcess;
import freenet.client.GetRequestProcess;
import freenet.client.FreenetURI;
/**
 * Command pluging for Get (ie DataRequest).
 *
 * @author oskar
 */
public class GetCommand implements ClientCommand {

    public GetCommand() {
    }

    public String getName() {
        return "get";
    }

    public String getUsage() {
        return "get <URI>";
    }

    public String[] getDescription() {
        return new String[] {
            "Retrieve a file from Freenet. The file will be written to the file given",
            "or to stdout if there was no file argument. Metadata control documents",
            "will be followed unless --noredirect was set"
        };

    }

    public int argCount() {
        return 1;
    }

    public RequestProcess getProcess(Params p, Bucket metadata, 
                                     Bucket data) throws CLIException {
        if (p.getNumArgs() < 2)
            throw new CLIException("get command requires URI as argument");
        FreenetURI uri;
        try {
            uri = new FreenetURI(p.getArg(1));
        } catch (java.net.MalformedURLException e) {
            throw new CLIException("malformed URI: " + e);
        }
        int htl = p.getInt("htl");
        return new GetRequestProcess(uri, htl, data, new FileBucketFactory(),
                                     0, p.getParam("noredirect") == null);
    }

    public boolean takesData() {
        return false;
    }

    public boolean givesData() {
        return true;
    }



}
