package freenet.client.metadata;
import freenet.FieldSet;
import freenet.client.FreenetURI;

//import freenet.support.Bucket;
//import java.io.InputStream;

public class InfoPart extends MetadataPart {

    public static final String name = "Info";

    private String format;
    private String description;

    // maybe we should have a mimetype class :-)
    public InfoPart(String description, String format) {
        this.format = format;
        this.description = description;
    }

    public InfoPart(String description) {
        this(description, null);
    }

    public InfoPart(FieldSet fs) throws InvalidPartException {
        format = fs.get("Format");
        description = fs.get("Description");
    }

    public String name() {
        return name;
    }

    public final String format() { return format; }

    public boolean isControlPart() {
        return false;
    }

    public void addTo(FieldSet fs) {
        FieldSet me = new FieldSet();
        if (description != null) {
	    me.add("Description", description);
	}

        if (format != null) {
            me.add("Format", format);
	}

        fs.add(name(), me);
    }

    public String toString() {
        return "Info: " + description + " (" + (format == null ? "" : format) + ")";
    }
}
