package freenet.client.metadata;
import freenet.FieldSet;
import freenet.client.Request;
import freenet.client.RequestProcess;
import freenet.client.GetRequestProcess;
import freenet.client.PutRequestProcess;
import freenet.client.FreenetURI;
import freenet.support.Bucket;
import freenet.support.BucketFactory;

public class Redirect extends MetadataPart {

    public static final String name = "Redirect";
    
    protected FreenetURI target;

    public Redirect(FreenetURI target) {
        this.target = target;
    }

    public Redirect(FieldSet fs) throws InvalidPartException {
        try {
            if (fs.get("Target") == null) {
                throw new InvalidPartException(name() + ": Requires target");
            }
            target = new FreenetURI(fs.get("Target"));
            
        } catch (java.net.MalformedURLException e) {
            throw new InvalidPartException(name() + ": malformed URI: " 
                                           + e.getMessage());
        }
    }

    public void addTo(FieldSet fs) {
        FieldSet me = new FieldSet();
        //System.err.println("LALA Converting myself " + target);
        me.put("Target", getTarget().toString());
        fs.add(name(), me);
    }

    public FreenetURI getTarget() {
        return target;
    }

    public void setTarget(FreenetURI target) {
        this.target = target;
    }

    public String name() {
        return name;
    }

    public boolean isControlPart() {
        return true;
    }

    public RequestProcess getGetProcess(FreenetURI furi, int htl, Bucket data, 
                                        BucketFactory ptBuckets, 
                                        int recursionLevel) {

        return new GetRequestProcess(/*getTarget()*/ getRequestTarget(furi), 
                                     htl,
                                     data, ptBuckets, ++recursionLevel);
    }

    public RequestProcess getPutProcess(FreenetURI furi, int htl, 
                                        String cipher, Metadata next, 
                                        Bucket data, BucketFactory ptBuckets,
                                        int recursionLevel, boolean descend) {

        return new RedirectPutProcess(getTarget(), htl, cipher, next, data, 
                                      ptBuckets,
                                      ++recursionLevel, descend);
    }

    protected FreenetURI getRequestTarget(FreenetURI furi) {
        return target.addMetaStrings(furi.getAllMetaStrings());
    }

    /**
     * I tunnel the PutRequestProcess through here so I can reset target.
     */
    private class RedirectPutProcess extends PutRequestProcess {

        public RedirectPutProcess(FreenetURI furi, int htl, 
                                  String cipher, Metadata next, 
                                  Bucket data, BucketFactory ptBuckets,
                                  int recursionLevel, boolean descend) {
            super(furi, htl, cipher, next, data, ptBuckets, recursionLevel,
                  descend);
        }

        public Request getNextRequest() {
            Request r = super.getNextRequest();
            if (r == null && getURI() != null)
                target = getURI();
            //System.err.println("LALA: Got new target " + target);
            return r;
        }
    }

    public String toString() {
        return "Redirect -> " + target;
    }
}

