package freenet.fs.acct;

import java.io.DataOutput;
import java.io.IOException;

/**
 * A hook provided by the user of an AccountingProcess that is called
 * when the AccountingProcess needs to freeze the current contents of
 * a data block to disk.  Since the block number changes at this time,
 * the new block number is passed back.
 * @author tavin
 */
public interface BlockEntry {

    /**
     * @param dest  the block number being written to
     * @param out   you write the data to this
     */
    void freeze(int dest, DataOutput out) throws IOException;
}


