package freenet.message;
import freenet.*;
import freenet.support.KeyList;
import freenet.node.Node;
import java.io.*;

/**
 * The final message in an AnnouncementChain (phew).
 *
 * @author oskar
 */

public class AnnouncementComplete extends NodeMessage {

        public static final String messageName = "AnnouncementComplete";

    private KeyList keys;
    private InputStream in;
    
    public AnnouncementComplete(long id, KeyList keys) {
        super(id, null);
        this.keys = keys;
    }
    
    public AnnouncementComplete(ConnectionHandler ch, RawMessage raw) 
        throws InvalidMessageException {
        
        super(ch, raw);
        keys = new KeyList();
        in = (raw.trailingFieldLength == 0 ? null : raw.trailingFieldStream);
    }
    
    public RawMessage toRawMessage(Presentation p) {
        RawMessage raw = super.toRawMessage(p);
        //raw.messageType = messageName;   
        raw.trailingFieldName = "Keys";
        raw.trailingFieldLength = keys.streamLength();
        //if (raw.trailingFieldLength != 0)
        //    raw.trailingFieldStream = keys.getStream();

        return raw;
    }

    public String getMessageName() {
        return messageName;
    }

    /** Read up to limit values from the stream into the list.
      */
    public void readKeys(int limit) throws IOException {
        if (in == null)
            return;
        try {
            KeyList.readKeyList(in, keys, limit);
        }
        finally {
            try { in.close(); }
            catch (IOException e) {}
        }
    }

    public KeyList getKeys() {
        return keys;
    }

    public void setKeys(KeyList keys) {
        this.keys = keys;
    }

}
