package freenet.message;
import freenet.*;
import freenet.support.Fields;

/**
 * The message returned when an announcement has reached it's final node
 *
 * @author oskar
 */

public class AnnouncementReply extends NodeMessage {

    public static final String messageName = "AnnouncementReply";

    private byte[] returnVal;

    public AnnouncementReply(long id, byte[] returnVal) {
        super(id, null);
        this.returnVal = returnVal;
    }

    public AnnouncementReply(ConnectionHandler ch, RawMessage raw) 
        throws InvalidMessageException {

        super(ch, raw);

        String returnS = otherFields.get("ReturnValue");
        if (returnS == null || returnS.equals("")) {
            throw new InvalidMessageException("No return value");
        } else {
            try {
                returnVal = Fields.hexToBytes(returnS);
            } catch (NumberFormatException e) {
                throw new InvalidMessageException("Malformed return value");
            }
            otherFields.remove("ReturnValue");
        }
    }

    public RawMessage toRawMessage(Presentation p) {
        RawMessage raw = super.toRawMessage(p);
        //raw.messageType = messageName;
        raw.fs.add("ReturnValue",Fields.bytesToHex(returnVal));
        return raw;
    }

    public String getMessageName() {
        return messageName;
    }

    /**
     * Retuns the contents of the ReturnValue field
     */
    public byte[] getReturnVal() {
        return returnVal;
    }

}
