
package freenet.message;

import java.io.*;
import freenet.*;
import freenet.node.*;
import freenet.support.*;
import freenet.node.states.FNP.NewInsertRequest;

/**
 * The Request message for Inserting data. 
 *
 * @author oskar
 */

public class InsertRequest extends Request {

    public static final String messageName = "InsertRequest";

    public InsertRequest(long idnum, long htl, Key key, NodeReference ref,
                       FieldSet otherFields) {
	super(idnum, htl, key, ref, otherFields);
    }

    public InsertRequest(long idnum, long htl, Key key, NodeReference ref) {
	super(idnum, htl, key, ref);
    }
    
    public InsertRequest(ConnectionHandler source,
                         RawMessage raw) throws InvalidMessageException {
	super(source,raw);
    }

    public State getInitialState() {
	return new NewInsertRequest(id);
    }
    
    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw=super.toRawMessage(t);
	//raw.messageType="InsertRequest";
	return raw;
    }

    public String getMessageName() {
        return messageName;
    }

}






