package freenet.message.client;

import freenet.*;
import freenet.node.State;
import freenet.node.states.FCP.*;
import java.io.InputStream;

/** This is for the FCP GenerateCHK message.
  */
public class GenerateCHK extends ClientMessage {

    public static final String messageName = "GenerateCHK";

    public GenerateCHK(ConnectionHandler source, RawMessage raw) {
        super(source, raw, true);
    }

    public State getInitialState() {
        return formatError
            ? (State) new NewIllegal(id, source, "Error parsing GenerateCHK message.")
            : (State) new NewGenerateCHK(id, source);
    }

    public String getMessageName() {
        return messageName;
    }
}
