package freenet.node.rt;

import freenet.Key;
import freenet.Identity;
import freenet.node.NodeReference;

/**
 * Filters entries based on Identity.  This could be extended
 * to filter based on physical addresses.  Right now the
 * reason for this is to keep references to itself out of
 * the node's routing table.
 * @author tavin
 */
public class FilterRoutingTable implements RoutingTable {

    private final RoutingTable rt;
    private final Identity[] blockID;
    
    public FilterRoutingTable(RoutingTable rt, Identity blockID) {
        this(rt, new Identity[] { blockID });
    }

    public FilterRoutingTable(RoutingTable rt, Identity[] blockID) {
        this.rt = rt;
        this.blockID = blockID;
    }

    private final boolean blocks(Identity id) {
        for (int i=0; i<blockID.length; ++i) {
            if (id.equals(blockID[i]))
                return true;
        }
        return false;
    }

    public final void reference(Key k, NodeReference nr) {
        if (!blocks(nr.getIdentity()))
            rt.reference(k, nr);
    }


    public final boolean references(Identity id) {
        return rt.references(id);
    }

    public final Routing route(Key k) {
        return rt.route(k);
    }

    public final RoutingStore getRoutingStore() {
        return rt.getRoutingStore();
    }

    public final Object semaphore() {
        return rt.semaphore();
    }

    public final RTDiagSnapshot getSnapshot() {
        return rt.getSnapshot();
    }
}





