package freenet.node.states.announcement;
import freenet.node.*;
import freenet.*;
import freenet.message.AnnouncementExecute;
import freenet.support.*;
import freenet.support.io.ParseIOException;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import java.math.BigInteger;
import java.io.IOException;

/**
 * A superclass for the shared code between LastNode and ExecutePending states.
 */

public abstract class ExecuteHandler extends AnnouncementState {

    protected NoExecute ne;
    /** Starts as the return value (including this node). When Execute is
     *  handled, it gets all the other values XORed to it.
     */
    protected byte[] total;

    public ExecuteHandler(AnnouncementState st, NoExecute ne,
                          byte[] total) {
        super(st);
        this.ne = ne;
        this.total = total;
    }

    
    /**
     * Execute the announcement.
     * @param n   The node
     * @param ae  AnnouncementExecute message. myVal is added to it's keylist
     *            as a sideeffect.
     * @return The announcee key if successful, null otherwise. 
     */
    protected Key executeAnnounce(Node n, AnnouncementExecute ae) {

        ne.cancel();

        try {
            ae.readValueList(depth);
        }
        catch (ParseIOException e) {
            n.logger.log(this, "Parse error on AnnouncementExecute value list, rejecting",
                         e, Logger.DEBUG);
            return null;
        }
        catch (IOException e) {
            n.logger.log(this, "I/O error reading value list from AnnouncementExecute",
                         e, Logger.DEBUG);
            return null;
        }
        
        KeyList kl = ae.getValueList();
        kl.xorTotal(total);
        // note the order, total already contains myVal
        kl.addEntry(myVal);
        byte[] kh = kl.cumulativeHash(new SHA1());
        //System.err.println("LALA TOTAL: " + 
        //                       freenet.support.Fields.bytesToHex(total));

        if (kl.size() == (depth + 1) && 
            Util.byteArrayEqual(commitVal, kh) &&
            announcee.getIdentity().verify(ae.getRefSignature(),
                                           new BigInteger(1, total))) {
            
            // create key
            return new Key(total, 0, 0);

        } else {
            n.logger.log(this, "Rejecting execute, KLSIZE: " + kl.size() 
                         + " DEPTH: " + depth + " COMMITVAL: " + 
                         Fields.bytesToHex(commitVal) + " KH: " +
                         Fields.bytesToHex(kh), n.logger.DEBUG);

            return null;
        }

    }
}
