package freenet.node.states.announcement;
import freenet.*;
import freenet.node.*;
import freenet.message.*;
import freenet.crypt.SHA1;
import freenet.support.KeyList;
import freenet.support.Fields;
import java.util.Enumeration;
import java.math.BigInteger;
/**
 * The state object for terminating nodes in Announcement chains, 
 * which only need to wait for an reply to the AnouncementExecute.
 */

public class LastNode extends ExecuteHandler {

    public LastNode(AnnouncementState as, NoExecute ne) {
        super(as, ne, bCopy(as.myVal));
    }

    private static byte[] bCopy(byte[] b) {
        byte[] r = new byte[b.length];
        System.arraycopy(b, 0, r, 0, b.length);
        return r;
    }

    public String getName() {
        return "Last Announcement Node";
    }

    public State receivedMessage(Node n, AnnouncementExecute ae) 
        throws BadStateException {
        
        if (!origRec.equalsIdent(ae.peerIdentity())) {
            throw new BadStateException("AnnouncementExecute not from " +
                                        "original source!");
        }


        Key k = executeAnnounce(n, ae);

        if (k != null) { 

            sendComplete(n, k);

            // insert into Routing table
            n.rt.reference(k, announcee);
            return new AnnouncementDone(this);
            
        } else {

            AnnouncementFailed af = 
                new AnnouncementFailed(id,
                                       AnnouncementFailed.CORRUPT_EXECUTE);
            try {
                n.sendMessage(af, origRec);
            } catch (CommunicationException sfe) {
                n.logger.log(this, "Failed to send AnnouncementFailed",
                             sfe, n.logger.MINOR);
            }

            return null;
        }

    }

    public void sendComplete(Node n, Key k) {
        // find closest previous entry
        
        KeyList keys = new KeyList(n.ds.findClosestKeys(k, true, depth));
        
        /*
        System.err.println("LastNode - sending this key list:");
        try {
            keys.writeTo(System.err);
        }
        catch (java.io.IOException e) {
            e.printStackTrace();
        }
        */
                
        AnnouncementComplete ac = new AnnouncementComplete(id, keys);
        try {
            sendMessage(n, origRec, ac, keys); 
        } catch (CommunicationException e) {
            n.logger.log(this, "Failed to send AnnouncementComplete",
                         e, n.logger.MINOR);
        }
    }

    public State receivedMessage(Node n, NoExecute ne) {

        n.logger.log(this, "Did not receive AnnouncementExecute message, " +
                     "dropping chain", n.logger.MINOR);

        return null;

    }

    public State receivedMessage(Node n, QueryAborted ne) 
        throws BadStateException {

        this.ne.cancel();

        if (!origRec.equalsIdent(ne.peerIdentity())) {
            throw new BadStateException("QueryAborted from wrong peer");
        }

        n.logger.log(this, "Announcement query aborted by previous node",
                     n.logger.DEBUG);
       
        return null;
    }

}




