package freenet.node.states.announcing;
import freenet.node.states.announcement.*;
import freenet.node.states.request.*;
import freenet.*;
import freenet.node.*;
import freenet.message.*;
import freenet.support.*;
import freenet.support.io.*;
import java.util.Enumeration;
import java.io.*;
/**
 * Completes the announcement when it receives the final reply.
 *
 * @author oskar
 */

public class CompleteAnnouncement extends AnnouncingState {

    private Key result;
    private NoComplete nc;

    CompleteAnnouncement(ExecuteAnnouncement as, Key result, NoComplete nc) {
        super(as);
        this.result = result;
        this.nc = nc;
    }

    public String getName() {
        return "Complete My Announcement";
    }

    public boolean receives(MessageObject mo) {
        if (mo instanceof NoComplete)
            return nc == mo;
        else if (mo instanceof Message)
            return target.equalsIdent(((Message) mo).peerIdentity());
        else
            return false;
    }
    
    public State receivedMessage(Node n, NoComplete nc) throws BadStateException {
        if (nc != this.nc)
            throw new BadStateException("Not my NoComplete");
        n.logger.log(this,
            "Announcement attempt failed, no reply from: "+target,
            Logger.MINOR);
        return SendAnnouncement.makeTry(n, id, tryNumber+1, target, hopsToLive);
    }

    public State receivedMessage(Node n, AnnouncementFailed af) {
        nc.cancel();
        n.logger.log(this, "Announcement attempt failed: "
                           +af.reasonName(), Logger.NORMAL);
        return SendAnnouncement.makeTry(n, id, tryNumber+1, target, hopsToLive);
    }

    public State receivedMessage(Node n, AnnouncementComplete ac) {

        nc.cancel();
        
        n.diagnostics.occurrenceCounting("announcedTo", hopsToLive);

        try {
            ac.readKeys(hopsToLive);
        }
        catch (ParseIOException e) {
            n.logger.log(this, "Error parsing key list, attempting to continue",
                         e, Logger.MINOR);
        }
        catch (IOException e) {
            n.logger.log(this, "I/O error reading key list", e, Logger.MINOR);
            return null;
        }
        
        KeyList keys = ac.getKeys();


        /*
        System.err.println("CompleteAnnouncement - received this key list:");
        try {
            keys.writeTo(System.err);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        */
        
        keys.setCompareBase(result);
        keys.sort();
        keys.prune();

        AnnouncementRequestToken ft = new AnnouncementRequestToken(keys.size());

        int i = 0;
        for (Enumeration e = keys.keys() ; 
             e.hasMoreElements() && i < n.initialRequests ; i++) {
            Key k = (Key) e.nextElement();
            NewInitialRequest.schedule(n, k, ft);
        }
        
        return null;
    }
}




