package freenet.support;

import java.io.DataOutputStream;
import java.io.IOException;


/**
 * A generic Object that can be written to an output stream.
 * @see DataObjectPending
 * @see DataObjectUnloadedException
 */
public interface DataObject {

    /**
     * @return  the byte-length of the serialized form
     */
    int getDataLength();

    /**
     * Writes the serialized form of the object.
     */
    void writeTo(DataOutputStream out) throws IOException;
}

