package freenet.support;

import java.util.Enumeration;

public class LRUCache implements Cache {

    private final DoublyLinkedList lru = new DoublyLinkedListImpl();

    private final int maxItems;

    public LRUCache(int maxItems) {
        this.maxItems = maxItems;
    }
    
    public final void cache(Cacheable ca) {
        lru.push(ca);
        if (lru.size() > maxItems) {
            Cacheable old = (Cacheable) lru.shift();
            old.drop();
        }
    }

    public final void uncache(Cacheable ca) {
        lru.remove(ca);
    }

    public final void promote(Cacheable ca) {
        // if it's not in the cache, don't do anything
        if (lru.remove(ca) != null)
            lru.push(ca);
    }

    public final Enumeration elements() {
        return lru.elements();
    }
}


