package freenet.support;

public interface LoggerHook  {

    /** These indicate the verbosity levels for calls to log() **/
    
    /** This message indicates an error which prevents correct functionality**/
    public static final int ERROR = 3;
    /** A normal level occurrence **/
    public static final int NORMAL = 2;
    /** A minor occurrence that wouldn't normally be of interest **/
    public static final int MINOR = 1;
    /** An occurrence which would only be of interest during debugging **/
    public static final int DEBUGGING = 0;
    public static final int DEBUG = DEBUGGING;

  /**
   * Log a message
   * @param o The object where this message was generated.
   * @param source     The class where this message was generated.
   * @param message A clear and verbose message describing the event
   * @param e        Logs this exception with the message.
   * @param priority The priority of the mesage, one of Logger.ERROR,
   *                 Logger.NORMAL, Logger.MINOR, or Logger.DEBUGGING.
   */
  public abstract void log(Object o, Class source, String message, Throwable e,
			   int priority);
}
