package freenet.support;

public class Pair implements Mapper.Entry {

	public Object first;
	public Object last;

	public Pair(Object key, Object value) {
		first=key; 
		last=value;
	}
	
	/** Returns the key corresponding to this entry
	  * @return the key corresponding to this entry
	 **/
	public Object getKey() {
		return first;
	}

	/** Returns the value corresponding to this entry
	  * @return the value corresponding to this entry
	 **/
	public Object getValue() {
		return last;
	}

	/** Sets the value corresponding to this entry
	  * @return the previous value
	 **/
	public Object setValue(Object newval) {
		Object oldval = last;
		last = newval;
		return oldval;
	}
}
