.\"
.\"   $Id: ./catod.man $
.\"
.\"
.\" FreeWnn is a network-extensible Kana-to-Kanji conversion system.
.\" This file is part of FreeWnn.
.\" 
.\" Copyright Kyoto University Research Institute for Mathematical Sciences
.\"                 1987, 1988, 1989, 1990, 1991, 1992
.\" Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
.\" Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
.\" Copyright FreeWnn Project 1999, 2000
.\" 
.\" Maintainer:  FreeWnn Project   <freewnn@tomo.gr.jp>
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
.\"
.TH CATOD \  "13 May 1992"
.SH NAME
catod \- To convert the text format of a dictionary to binary 
        format.
.SH SYNOPSIS
catod  [-s 
.I maxword
] [-R] [-r] [-e] [-S] [-U] 
       [-P 
.I dicpasswd
]    [-p 
.I frepasswd
] 
       [-h 
.I cixingfile
] 
.I outfilename
.SH DEFAULT PATH
/usr/local/bin/cWnn4/catod
.ad
.SH DESCRIPTION
This command converts a dictionary from text format into 
binary format.

.I outfilename
is the name of the binary format dictionary.  
If 
.I outfilename
is not given, the output will be passed 
to the standard output device(stdout).

The input file may be piped in by using the "<" command.  
For example,
.sp 0
	catod  basic.dic  <  basic.u
.sp 0
"basic.dic" here is the output binary format dictionary, 
while the "basic.u" is the input text format dictionary.

If the input text dictionary is not given, the input will 
be taken from the standard input(stdin).  
To end the input via standard input, press ^D.
.SH OPTIONS
.IP -s 
.I maxword     
.sp 0
To specify the maximum number of words.  Default is 70000.
.IP -R 
To create a dictionary for both forward and reverse conversion.  (Default).
.IP -r 
To create a reverse format dictionary only for reverse conversion. 
.IP -e
If the Hanzi inside the text dictionary contains characters such as space 
and tab, they will be compacted to special format.  (Default).
.IP -S
To create a static dictionary.
.IP -U
To create a dynamic dictionary.
.IP -P 
.I dicpasswd   
.sp 0
To specify the password for the dictionary. 
.sp 0
If "-N" is used instead, the password of the dictionary will be set to "*".
.IP -p 
.I frepasswd   
.sp 0
To specify the password for the usage frequency file.  
.sp 0
If "-n" is used instead, the password of the frequency file will be set to "*".
.IP -h 
.I cixingfile  
.sp 0
To specify the Cixing definition file.
.SH NOTE
.IP 1.
The parts in [ ] are options.  They may be omitted.
.IP 2.
The Pinyin and Zhuyin dictionary has the same format.
.IP 3.
For details of the dictionary structure, refer to cWnn manual.
