
/*
    FUNIONFS: UNIONFS over FUSE Usermode filesystem
    Copyright (C) 2005-2006  Stephane APIOU <stephane.apiou@free.fr>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _FUNIONFS_H
#define _FUNIONFS_H

// use the new API

#define VERSION "0.4.2"

#define MAX_LINKPATH	4096
#define MAX_READLINKS	50

#define DELETED_STRING "_DELETED~"

#define FILE_EXIST	0X01
#define FILE_WRITEABLE	0X02
#define FILE_DELETED	0X04
#define FILE_CREATABLE	0X08
#define FILE_TODELETE	0X10

#define IDX_GET	0
#define IDX_PUT	1
#define IDX_NEW	2

#define _DEBUG	1

#if _DEBUG
#define DEBUG_PRINTF(args...) \
		do { if (f_opt.debug) fprintf(stderr, args); } while(0)
#else
#define DEBUG_PRINTF(args...)
#endif

#define CONTROL_FILE "._funionfs_control~"
#define CONTROL_BUFFER_SIZE (3*PATH_MAX)

#define LOG(args...)\
       do { if(log_fd) fprintf(log_fd, args); fflush (log_fd); } while(0)

struct unionfs_desc
{
	char *path;
	char ro;
	struct unionfs_desc *pnext;
};

struct unionfs_walk
{
	char *path;
	char *str;
	struct unionfs_desc *curdir;
};

typedef struct funionfs_options
{
	char *uid;
	char *gid;
	char *mode;
	int delete;
	int copyup;
	int debug;
	char *dirlist;
	char *firstdir;
	char *mountpoint;
	char *del_string;
	int del_len;
	char *log;
} f_opt_t;

typedef struct control_buffer
{
	char data[CONTROL_BUFFER_SIZE];
	long start;
	long length;
} f_cbuf_t;


int getrightstr(char *str, char *substr);

char *rel2abspath(char *relpath, char *basepath);

int funionfs_addpath(char *path, int ro);
int funionfs_realpath(const char *path, char **get_path, char **put_path,
		      char **new_path, struct unionfs_desc *tab[3]);
int funionfs_copytowrite(char *readpath, char *writepath);
int funionfs_pathtowrite(const char *path);

int parse_and_add_dirs(void);

struct unionfs_walk *funionfs_openpath(const char *path);
char *funionfs_readpath(struct unionfs_walk *pwalk, long *type);
int funionfs_closepath(struct unionfs_walk *pwalk);

int funionfs_control_write(const char *buf, size_t size);

int funionfs_relist(void);

#endif
