#!/usr/bin/awk -f

# rewritten from ruby version with the kind help of Soren Dossing

BEGIN{
	inside = -1;

	if (! (outf = ENVIRON["OUTF"])) {
		print "output file unspecified";
		exit 1;
	}

	while (getline)
	{
		if (inside == -1) {
			if ($0 ~ /^[[:space:]]*enum[[:space:]]+fuse_opcode[[:space:]]*\{/) 
				inside = 0;
			continue;
		}
		if ($0 ~ /^[[:space:]]*\}/)
			break;
		if (! ($0 ~ /^[[:space:]]*[A-Z_]+[[:space:]]*(,|=[[:space:]]*[[:digit:]]+)/))
			continue;
		sub(/,.*/,"");
		sub(/=/,"");
		$2 ? (inside = $2) : (inside += 1);
		if (ops[inside]) {
			print "colliding values for fuse opcodes:", inside, "<-", ops[inside], "vs.", $1 > "/dev/stderr";
			exit 1;
		}
		ops[inside] = $1;
	}
	inside += 5

	print "/* Generated by an awk script from fuse_kernel.h, don't hand hack it! */" >> outf;
	print "" >> outf;
	print "char *fuse_opnames[] = {" >> outf;
	for (o=0; o <= inside; o++) {
		print ops[o] ? "\t\""ops[o]"\"," : "\t\"N/A (your fuse_opnames.c is out of date?...)\"," >> outf;
	};
	print "};" >> outf;;
	print "" >> outf;
	print "int fuse_opnames_entries = "inside";" >> outf;
}
