from weakref import ref as weakref_ref

class Mailbox:
    def __init__(self, agent, mta):
        self.messages = []
        self.agent = weakref_ref(agent)
        for event in agent.getEvents():
            mta.registerMailingList(self, event)

    def clear(self):
        self.messages = []

    def deliver(self, message):
        if not self.agent().is_active:
            return
        self.messages.append(message)

    def __len__(self):
        return len(self.messages)

    def pop(self):
        message = self.messages[0]
        del self.messages[0]   # FIXME: use collection.deque
        return message

    def __repr__(self):
        agent = self.agent()
        if agent:
            return "<Mailbox of %r>" % agent
        else:
            return "<Mailbox>"

