<?php

/*
  This code is part of FusionDirectory (http://www.fusiondirectory.org/)
  Copyright (C) 2003-2010  Cajus Pollmeier
  Copyright (C) 2011-2013  FusionDirectory

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
*/

class applicationParameters extends plugin
{
  /* Parameters  */
  var $option_name  = array();
  var $option_value = array();

  /* attribute list for save action */
  var $attributes = array("gosaApplicationParameter");

  function __construct (&$config, $dn = NULL, $parent = NULL)
  {
    parent::__construct($config, $dn, $parent);

    $this->gosaApplicationParameter = array();

    if (isset($this->attrs['gosaApplicationParameter'])){
      $this->is_account= TRUE;
      for ($i= 0; $i<$this->attrs['gosaApplicationParameter']['count']; $i++){
        $option= preg_replace('/^[^:]+:/', '',
            $this->attrs['gosaApplicationParameter'][$i]);
        $name= preg_replace('/:.*$/', '',
            $this->attrs['gosaApplicationParameter'][$i]);
        $this->option_name[$i]= $name;
        $this->option_value[$i]= $option;
      }
    } else {
      $this->is_account= FALSE;
    }
  }

  function execute()
  {
    /* Call parent execute */
    parent::execute();

    /* Do we need to flip is_account state? */
    if(isset($_POST['modify_state'])){
      if($this->is_account && $this->acl_is_removeable()){
        $this->is_account= FALSE;
      }elseif(!$this->is_account && $this->acl_is_createable()){
        $this->is_account= TRUE;
      }
    }

    /* Show tab dialog headers */
    $display= "";
    if ($this->parent !== NULL){
      if ($this->is_account){
        $display= $this->show_disable_header(_("Remove options"),msgPool::featuresEnabled(_("parameter")));
      } else {
        $display= $this->show_enable_header(_("Create options"), msgPool::featuresDisabled(_("parameter")));
        $this->parent->by_object['application']->generateTemplate();
        return ($display);
      }
    }

    if($this->acl_is_writeable("gosaApplicationParameter")){

      /* Add option to list */
      if (isset($_POST['add_option'])){
        $i= count($this->option_name);
        $this->option_name[$i]= "";
        $this->option_value[$i]= "";
      }

      /* Remove value from list */
      for ($i= 0; $i<count($this->option_name); $i++){
        if (isset($_POST["remove$i"])){
          $k= 0;
          $on= array();
          $ov= array();
          for ($j= 0; $j<count($this->option_name); $j++){
            if ($j != $i){
              $on[$k]= $this->option_name[$j];
              $ov[$k]= $this->option_value[$j];
              $k++;
            }
          }
          $this->option_name= $on;
          $this->option_value= $ov;
          break;
        }
      }
    }

    /* Generate list of attributes */
    if (count($this->option_name) == 0){
      $this->option_name[]= "";
      $this->option_value[]= "";
    }

    $acl = $this->getacl("gosaApplicationParameter")  ;
    $table= "<table><tr><td>"._("Variable")."</td><td>"._("Default value")."</td><td></td></tr>";
    if (count ($this->option_name)){

      for ($i= 0; $i < count($this->option_name); $i++){
        $name = $this->option_name[$i];
        $value= $this->option_value[$i];

        $tag = "";
        if(!preg_match("/w/",$acl)){
          $tag = " disabled ";
        }

        if(!preg_match("/r/",$acl)){
          $name = "";
          $value= "";
        }

        $table.="<tr>".
          " <td>".
          "  <input name=\"option$i\" size=25 maxlength=50 value=\"".$name."\" ".$tag.">".
          " </td>".
          " <td>".
          "  <input name=\"value$i\" size=60 maxlength=250 value=\"".$value."\" ".$tag.">".
          "  <br>".
          " </td>".
          " <td>".
          "  <input type=\"submit\" name=\"remove$i\" value=\""._("Remove")."\" ".$tag.">".
          " </td>".
          "</tr>";
      }
    }
    $table.= "</table>";
    $table.="<input type=\"submit\" name=\"add_option\" $tag value=\""._("Add option")."\">";

    /* Show main page */
    $smarty= get_smarty();
    $tmp = $this->plInfo();
    foreach($tmp['plProvidedAcls'] as $name => $translation){
      $smarty->assign($name."ACL",$this->getacl($name));
    }

    $smarty->assign("table", $table);
    $display.= $smarty->fetch(get_template_path('parameters.tpl', TRUE));
    $this->parent->by_object['application']->generateTemplate();
    return $display;
  }

  function remove_from_parent()
  {
    $ldap= $this->config->get_ldap_link();

    /* Zero attributes */
    $this->attrs= array();
    $this->attrs['gosaApplicationParameter']= array();

    $ldap->cd($this->dn);
    @DEBUG (DEBUG_LDAP, __LINE__, __FUNCTION__, __FILE__,
        $this->attributes, "Save");
    $this->cleanup();
    $ldap->modify ($this->attrs);

    if (!$ldap->success()){
      msg_dialog::display(_("LDAP error"), msgPool::ldaperror($ldap->get_error(), $this->dn, LDAP_MOD, get_class()), LDAP_ERROR);
    }

    /* Optionally execute a command after we're done */
    $this->handle_post_events('remove');
  }

  /* Save data to object */
  function save_object()
  {
    if (isset($_POST['option0']) && $this->acl_is_writeable("gosaApplicationParameter")){
      for ($i= 0; $i<count($this->option_name); $i++){
        $this->option_name[$i]= $_POST["option$i"];
        $this->option_value[$i]= "";
        if ($_POST["value$i"] != ""){
          $this->option_value[$i]= $_POST["value$i"];
        }
      }
    }
  }

  /* Check values */
  function check()
  {
    /* Call common method to give check the hook */
    $message= plugin::check();

    /* Check for valid option names */
    for ($i= 0; $i<count($this->option_name); $i++){
      /* Check for empty option names */
      if (!$this->option_name[$i]) {
        $message[]= msgPool::required(_("Name"));
      }
      /* Check for valid option names */
      elseif (!preg_match ("/^[a-z0-9_]+$/i", $this->option_name[$i])){
        $message[]= msgPool::invalid(_("Name"), $this->option_name[$i],"/^[a-z0-9_]+$/i");
      }
    }

    return $message;
  }

  /* Save to LDAP */
  function save()
  {
    /* Generate values */
    $this->attrs= array();
    if (count($this->option_name) == 0){
      $this->attrs['gosaApplicationParameter']= array();
    } else {
      for ($i= 0; $i<count($this->option_name); $i++){
        $this->attrs['gosaApplicationParameter'][]= $this->option_name[$i].
          ":".$this->option_value[$i];
      }
    }

    /* Write back to ldap */
    $ldap= $this->config->get_ldap_link();
    $ldap->cd($this->dn);
    @DEBUG (DEBUG_LDAP, __LINE__, __FUNCTION__, __FILE__,
        $this->attributes, "Save");
    $this->cleanup();
    $ldap->modify ($this->attrs);

    if (!$ldap->success()){
      msg_dialog::display(_("LDAP error"), msgPool::ldaperror($ldap->get_error(), $this->dn, LDAP_MOD, get_class()), LDAP_ERROR);
    }

    /* Optionally execute a command after we're done */
    $this->handle_post_events('modify');
  }

  function PrepareForCopyPaste($source)
  {
    plugin::PrepareForCopyPaste($source);

    $source_o = new applicationParameters($this->config,$source['dn']);
    $this->option_name = $source_o->option_name;
    $this->option_value = $source_o->option_value;

    /* Set is_account state so that the save function is called properly */
    $this->is_account = TRUE;
  }

  /* Return plugin informations for acl handling */
  static function plInfo()
  {
    return array(
      "plShortName"   => _("Parameter"),
      "plDescription" => _("Parameter configuration"),
      "plSelfModify"  => FALSE,
      "plObjectType"  => array("application"),

      "plProvidedAcls"=> array(
        "gosaApplicationParameter" => _("Application parameter settings")
      )
    );
  }
}
?>
