/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.graphApi.io;

import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphSystem;
import hypergraph.graphApi.io.ContentHandlerFactory;
import hypergraph.graphApi.io.DefaultLexicalHandler;
import hypergraph.graphApi.io.LexicalHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXReader {
    private GraphSystem graphSystem;
    private InputSource inputSource;
    private Graph graph;
    private LexicalHandler lexicalHandler;
    private XMLReader reader;
    private ContentHandlerFactory contentHandlerFactory;

    public SAXReader(GraphSystem graphSystem, String string) throws FileNotFoundException, IOException {
        this.graphSystem = graphSystem;
        this.inputSource = new InputSource(string);
        this.createLexicalHandler();
    }

    public SAXReader(GraphSystem graphSystem, URL uRL) throws IOException {
        this.graphSystem = graphSystem;
        this.inputSource = new InputSource(uRL.openStream());
        this.inputSource.setSystemId(uRL.toString());
        this.createLexicalHandler();
    }

    void createLexicalHandler() {
        this.lexicalHandler = new DefaultLexicalHandler();
    }

    public GraphSystem getGraphSystem() {
        return this.graphSystem;
    }

    public XMLReader getReader() {
        return this.reader;
    }

    public void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        this.contentHandlerFactory = contentHandlerFactory;
    }

    public ContentHandlerFactory getContentHandlerFactory() {
        return this.contentHandlerFactory;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Graph parse() throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        this.reader = sAXParser.getXMLReader();
        this.lexicalHandler.setSAXReader(this);
        this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
        this.reader.parse(this.inputSource);
        return this.getGraph();
    }
}

