/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP35Dialog.cc,v 1.25 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "DiscoveryDruidP35Dialog.hh"
#include "Preferences.hh"
#include "fwbuilder/dns.hh"

#include <Druid.hh>

#include <gtk--.h>

using namespace libfwbuilder;


class AQueryPool: public Pool<DNS_findA_query>
{
    private:
    
    static AQueryPool *instance;
    static Mutex       ap_mutex;
    
    public:
    
    AQueryPool(size_t initial, size_t max_):Pool<DNS_findA_query>(initial, max_) {}
    
    static AQueryPool *getInstance()
    {
        ap_mutex.lock();
        if(instance==NULL)
            instance=new AQueryPool(0, 32);
        ap_mutex.unlock();
        return instance;
    }
/*
    virtual DNS_findA_query *lease()
    {
        cerr << "Leasing ";
        DNS_findA_query *res=Pool<DNS_findA_query>::lease();
        cerr << res << endl;
        return res;
    }

    virtual void release(DNS_findA_query *t)
    {
        cerr << "Releasing " << t << endl;
        Pool<DNS_findA_query>::release(t);
    }

    virtual DNS_findA_query *create()
    {
        cerr << "Creating ";
        DNS_findA_query *res=Pool<DNS_findA_query>::create();
        cerr << res << endl;
        return res;
    }
*/
};

AQueryPool *AQueryPool::instance=NULL;
Mutex AQueryPool::ap_mutex;

DiscoveryDruidP35Dialog::DiscoveryDruidP35Dialog()
{
    p35_txt->set_line_wrap(true);
    data_ready=false;
    q=NULL;
}

/*
 *  If page gets destroyed we need to check if there is any background
 *  operation in progress. If there is, we will stop it and disconnect
 *  signal from callback
 *
 *  This has been tested: this widget's destrutor is called when
 *  user clicks "Cancel" in druid or simply closes druid window. If
 *  operation is in progress at that moment, this widget must
 *  disconnect its callback before it dies
 *  
 *  (vk)
 */
DiscoveryDruidP35Dialog::~DiscoveryDruidP35Dialog()
{
    if (q!=NULL && q->get_running_flag())
	stop_operation();
}

int DiscoveryDruidP35Dialog::execute(const string& domain_name,
				     const IPAddress& ns)
{
    data_ready=false;

    /*
     *  disable "Next" button
     */
    Gtk::Widget *dr = glademm_get_Widget("DiscoveryDruid");
    ((Druid*)dr)->set_buttons_sensitive(true,false,true);
    
    q=AQueryPool::getInstance()->lease();
    q->init(domain_name , ns,
            Preferences::global_prefs->getOptInt("/FWBuilderPreferences/Network/DNSRetries", RES_DFLRETRY),
            Preferences::global_prefs->getOptInt("/FWBuilderPreferences/Network/DNSTimeout", RES_TIMEOUT)
    );
    
    bow=manage(new BackgroundOpWidget(q,false) ); // not modal 
    bow->show();

    Gtk::Widget *w=dns_op_progress_frame->get_child();
    if (w)  dns_op_progress_frame->remove();  // remove bow

    dns_op_progress_frame->add(*bow);
    
    try
    {
        bow->execute();   // not modal, this just starts operation
        completed_conn=bow->completed.connect(SigC::slot(this,
				  &DiscoveryDruidP35Dialog::on_completed));
    } catch(const FWException &ex)
    {
        AQueryPool::getInstance()->release(q); q=NULL;
    }

    return 0;
}

void DiscoveryDruidP35Dialog::stop_operation()
{
    q->detach((Pool<BackgroundOp>*)(AQueryPool::getInstance()));
    q->stop_operation();
    data_ready=false;
    completed_conn.disconnect();
}


bool DiscoveryDruidP35Dialog::ready()
{
    return data_ready;
}

int DiscoveryDruidP35Dialog::on_completed(int arg)
{
    hosts.clear();

    map<string,set<IPAddress> > t = q->getResult();

    for(map<string,set<IPAddress> >::iterator j = t.begin(); 
	j!=t.end(); ++j) {

	ObjectDescriptor od;
	od.addr     = *((*j).second.begin());
	od.sysname  = (*j).first;

	hosts.push_back(od);
    }


    AQueryPool::getInstance()->release(q); q=NULL;
    data_ready=true;
    completed_conn.disconnect();

    if (arg==0) {
	bow->showStatusMessage("DNS query completed successfully, click 'Next' to continue");
// enable "Next" button
	Gtk::Widget *dr= glademm_get_Widget("DiscoveryDruid");
	((Druid*)dr)->set_buttons_sensitive(true,true,true);
    } else
	bow->showStatusMessage("There has been an error running DNS query");

    return 0;
}

