/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ICMPServiceDialog.hh,v 1.5 2001/09/21 20:08:53 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/




#ifndef _ICMP_SERVICEDIALOG_HH
#  include "ICMPServiceDialog_glade.hh"
#  define _ICMP_SERVICEDIALOG_HH
#include "glademm_support.hh"

class ICMPServiceDialog : public ICMPServiceDialog_glade
{   
        
        friend class ICMPServiceDialog_glade;

    void on_any_type_toggled();

    void on_type_changed();
    void on_code_changed();

    void on_changed();

    void  _fill_type(bool empty_type);
    void  _fill_code(int  type);
    void  _set_type(int t);
    void  _set_code(int t,int c);
    int   _get_table_entry_for_type(int type);
    int   _get_val_by_desc(const char* desc);
    char* _get_type_desc(int t);
    char* _get_code_desc(int t,int c);
    int   _get_type_by_desc(string desc);
    int   _get_code_by_desc(string desc);
    
public:

  ICMPServiceDialog(libfwbuilder::FWObject *obj);

  virtual void wrk2dlg();
  virtual bool dlg2wrk();


};
#endif




