/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: fwbuilder.cc,v 1.67 2001/12/29 10:06:36 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#ifdef HAVE_LOCALE_H
#include <locale.h>
#endif


#include <gtk--/main.h>
#include <popt.h>

#include <glib.h>
#include <gdk_imlib.h>

#include "fwbuilder/FWObject.hh"
#include "FWObjectDatabaseGUI.hh"
#include "helpers.hh"
#include "ttips.hh"

#include "main_window.hh"
#include "FWObjectBook.hh"

#include "Resources.hh"
#include "Preferences.hh"
#include "MessageDialog.hh"
#include "fwbuilder/XMLTools.hh"

#include "glademm_support.hh"

#include <iostream.h>

using namespace libfwbuilder;


class StaticInitializer
{
    public:
    
    StaticInitializer()
    {
        /* init threads */
        g_thread_init(NULL);
    }
} init;

static char      *filename   = NULL;
main_window      *main_w     = NULL;

struct poptOption options[] = 
{
    { "file", 'f', POPT_ARG_STRING, &filename, 0,
      "File to load on startup", "filename" },
    POPT_AUTOHELP
    { NULL, 0, 0, NULL, 0 }
};

/**
 *   This handler gets called whenever gtk event loop is stopped via 
 *   Gtk::Main::quit()
 */

gint quit_handler()
{
    if (gtk_main_level()==1) {
// this is the  end of program


    }
    return true;
}


int main(int argc, const char **argv)
{   
#ifdef HAVE_SETLOCALE
    setlocale(LC_ALL, "");
#endif

    gdk_threads_enter();
 

    /* Init XML parser */
    XMLTools::initXMLTools();


    gtk_rc_parse( TEMPLATE_DIR "/gtkrc" );

    Gtk::Main m(&argc, (char***)(&argv) );

    gdk_imlib_init();

    gtk_widget_push_visual (gdk_imlib_get_visual ());  
    gtk_widget_push_colormap(gdk_imlib_get_colormap());

    poptContext con=poptGetContext(NULL, argc,  argv, options, 0 );
    int rc = poptGetNextOpt(con);
    if (rc<-1) {
	poptPrintUsage(con,stderr,0);
	exit(1);
    }
    poptFreeContext(con);



/* pretty much everything else in the GUI uses resources, so we start here */
    try  
    {
        new Resources();       // creates singleton Resources::global_res
    } catch(FWException &ex)  
    {
        /*
         *  Error loading resources. MessageDialog needs Resources (for
         *  icons), so we can't use it to show error message.  
         */
	cerr << ex.toString() << endl;
        exit(1);
    }


    try  {
        new Preferences();     // creates singleton Preferences::global_prefs
    } catch(FWException &ex)  {
	MessageDialog::Error(ex.toString());
        exit(1);
    }

   
    main_w = new main_window();

    if ( Preferences::global_prefs->getOptBool(
	     "/FWBuilderPreferences/UI/RememberWindowPositionAndSize") ) {

	main_w->restoreWindowConfiguration();
    } 

    main_w->restoreWindowPosition();

    main_w->show_all();

    new FWObjectClipboard(); // creates singleton 
    new FWObjectDatabaseGUI();  // creates db and scratchpad

    try   {
	if(filename)  {
	    //load file given on command line
	    FWObjectDatabaseGUI::getInstance()->load(filename);
	} else  {
	    //load default file
	    string dbTemplateFile = 
		TEMPLATE_DIR  "/" + FWObjectDatabaseGUI::DB_TEMPLATE_FILE_NAME;
	    FWObjectDatabaseGUI::getInstance()->load(dbTemplateFile);
	    FWObjectDatabaseGUI::getInstance()->setFileName("");
	}
    } catch(FWException &ex)  {
	MessageDialog::LongTextError(ex.toString());
	exit(1);
    }
   
    FWObjectBook *book=(FWObjectBook*)glademm_get_Widget("FWObjectBook");
    assert (book!=NULL);

    book->build();
    main_w->setCurrentLibrary("");
    main_w->schedule_open_object(FWObjectDatabaseGUI::db->std.rootId);

    InitializeTooltips();

    Gtk::Main::quit.connect( SigC::slot( &quit_handler )  ) ;

    m.run();
    gdk_threads_leave();

    if ( Preferences::global_prefs->getOptBool(
	     "/FWBuilderPreferences/UI/RememberWindowPositionAndSize") ) {

	main_w->saveWindowConfiguration();
	
    }

    return 0;
}









