/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: main_window2.cc,v 1.42 2001/12/29 10:06:36 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include <iostream>
#include <gtk--/base.h>
#include <gtk--/main.h>
#include <gtk--/tree.h>

#include "config.h"

#include "glademm_support.hh"

#include "helpers.hh"

#include "main_window.hh"

#include "fwbuilder/FWObjectDatabase.hh"
#include "FWObjectDatabaseGUI.hh"

#include "fwbuilder/Group.hh"
#include "fwbuilder/ObjectGroup.hh"
#include "fwbuilder/ServiceGroup.hh"

#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/InterfacePolicy.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/NAT.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/RuleElement.hh"

#include "GroupDialog.hh"
#include "BuiltinDialog.hh"
#include "DialogPlugin.hh"
#include "Preferences.hh"

#include "FindDialog.hh"
#include "WhereUsedDialog.hh"

#include "gen_popup_menu.hh"


#include "MessageDialog.hh"

using namespace libfwbuilder;


bool main_window::safe_to_close_right_pane()
{
  if ( current_right_pane_dialog!=NULL &&
       current_right_pane_dialog->IsDataChanged()) {
    // unsaved changes exist
      
      if ( Preferences::global_prefs->getOptBool("/FWBuilderPreferences/UI/Autosave") ) {
	  Gtk::Widget *w=right_pane_port->get_child();
	  if (w) {
	      BuiltinDialog *dlg = dynamic_cast<BuiltinDialog*>(w);
	      if (dlg)
		  dlg->SaveData();
	  }
	  return true;

      } else {

	  MessageDialog::Warning(
"Data in the current dialog
has been modified. Please
save or discard your changes.");

	  return false;
      }
  }
  return true;
}


void main_window::schedule_open_object(string id)
{
    oo_obj=id;
    Gtk::Main::idle.connect(slot(this,&main_window::open_object_when_idle));
}

gint main_window::open_object_when_idle()
{
    if (oo_obj=="") return false;
    OpenObject(oo_obj);
    oo_obj="";
    return false;
}

void main_window::ClearRightPane(bool logo)
{
    if(right_pane_port)
    {
        Gtk::Widget *w=right_pane_port->get_child();
        if (w!=0) {
            w->hide();
            right_pane_port->remove(); 

	    if ( ! Gtk::Label::isA(w))  delete w;

	    current_right_pane_dialog=NULL;
        }
    }      

    if (logo) 
    {
        /*
         *   TODO:  show logo in the right pane if there is going to be no dialog
         */
    }

    Gtk::Widget *itm;

    itm=find_widget("duplicate",main_menubar1);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("copy",main_menubar1);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("cut",main_menubar1);
    if (itm) itm->set_sensitive(false);

    itm=find_widget("paste",main_menubar1);
    if (itm) itm->set_sensitive(false);
}

bool main_window::OpenObject (string id)
{
    if(!safe_to_close_right_pane())         return false;
    
    ClearRightPane(false);

/*
 *  this automatically switches to the right tree view if necessary
 */
//    if (pane_docked) obook->showObject(id , current_lib );
//    else             obook->clearSelection();

    obook->showObject(id , current_lib );

/* child of right_pane_port is deleted in ClearRightPane */
    BuiltinDialog *dptr = new BuiltinDialog(id);
    
    if(dptr) 
    {
	dptr->LoadData();

	//  right_pane_port->remove(); 
	right_pane_port->add( *dptr );
        
	dptr->show();
	right_pane_port->show();

	current_right_pane_dialog=dptr;
    }
    
    if (dptr && dptr->getDialog()!=NULL)
	dptr->getDialog()->updateMainMenu();

//    FWObject *o=nowShowingObject();

    return true;
}



void  main_window::on_new_fw()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newFirewall();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_host()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newHost();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_net()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newNetwork();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_obj_group()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newObjectGroup();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_ip()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newIPService();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_icmp()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newICMPService();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_tcp()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newTCPService();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_udp()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newUDPService();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_srv_group()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newServiceGroup();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_custom()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newCustomService();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}

void  main_window::on_new_time()
{
    if ( safe_to_close_right_pane() ) {
	FWObject *o=FWObjectDatabaseGUI::newInterval();
	obook->showPage(0);  // User-defined objects
	obook->insertObject( o );
    }
}




void main_window::on_cutobj()
{   
    string id=obook->getCurrentSelection();
    FWObject *obj=FWObjectDatabase::db->getById( id, true);
    if ( ! Resources::isSystem(obj) && 
	 ! InterfacePolicy::isA(obj)  && 
	 ! Policy::isA(obj)  && 
	 ! NAT::isA(obj) ) {

	FWObjectClipboard::obj_clipboard->putObject(obj);
	on_delobj();
    }
}

/*
 * this method checks if object with given id is referenced by some group
 * or firewall policy and shows a warning
 * If object is not referenced, it stills shows "yes/no" dialog to ask user
 * whether they are sure object is to be deleted
 *
 * This method should be called to confirm non-reversible deletion of
 * real objects, not references.
 */
bool main_window::confirm_remove_object(const string& id)
{
    FWObject *obj=FWObjectDatabase::db->getById( id, true);
    if ( ! Resources::isSystem(obj) && 
	 ! InterfacePolicy::isA(obj)  && 
	 ! Policy::isA(obj)  && 
	 ! NAT::isA(obj) ) {

//	cerr << "start scanning tree: " << time(NULL) << endl;
	set<FWReference*> refs=FWObjectDatabase::db->findAllReferences(obj);
//	cerr << "done scanning tree: " << time(NULL) << endl;

	if (refs.size()!=0) {

/*
 * This object is referenced from some other groups or policies. Issue
 * a warning for the user.
 */
	    MessageDialog::DlgReturnValue a = MessageDialog::YesNo(
"This object is used in groups or policies.\n\
The operation you have chosen will remove it\n\
and all the references to it from the database.\n\
Are you sure you want to delete it ? "
);
	    return (a==MessageDialog::OK_YES);
	    
	} else {
	    MessageDialog::DlgReturnValue a = MessageDialog::YesNo(
"This operation will remove this object from the database.\n\
Are you sure you want to delete it ?"
);
	    return (a==MessageDialog::OK_YES);
	}

    }
    return false;
}

void main_window::on_delobj()
{   
    string id=obook->getCurrentSelection();
    if (confirm_remove_object(id)) {
	
	FWObject *obj=FWObjectDatabase::db->getById( id, true);

	ClearRightPane(true);

	FWObject *p=obj->getParent();
	obook->removeObject(obj);

	FWObjectDatabase::db->removeAllInstances(obj);
	obj=FWObjectDatabaseGUI::ScratchPad->getById( id , true);
	FWObjectDatabaseGUI::ScratchPad->removeAllInstances(obj);

	OpenObject( p->getId() );
    }
}

void main_window::on_where_used()
{   
    string id=obook->getCurrentSelection();
    FWObject *obj=FWObjectDatabase::db->getById( id, true);

    set<FWReference*> refs=FWObjectDatabase::db->findAllReferences(obj);
    set<FWObject*>    objects;

    FWObject *o;
    set<FWReference*>::iterator m;
    for (m=refs.begin(); m!=refs.end(); ++m) {
	if ( (o=(*m))!=NULL ) {
	    o=o->getParent();
	    if ( RuleElement::cast(o)!=NULL) {
		while ( o!=NULL && Firewall::cast(o)==NULL )
		    o=o->getParent();
	    }

	    if (o) objects.insert(o);
	}
    }
    WhereUsedDialog *wud=manage(new WhereUsedDialog( obj , objects ));
    wud->run();
}

void main_window::on_duplicate()
{   
    string id=obook->getCurrentSelection();
    if ( safe_to_close_right_pane() ) {
	FWObject *obj=FWObjectDatabase::db->getById( id , true);
	if (obj && ! Resources::isSystem(obj) ) {
	    FWObject *parent=obj->getParent();
	    assert (parent!=NULL);
	    pasteTo(parent,obj);
	}
    }
}

void main_window::on_copyobj()
{   
    string id=obook->getCurrentSelection();
    if ( safe_to_close_right_pane() ) {
	FWObject *obj=FWObjectDatabase::db->getById( id , true);
	if (obj && ! Resources::isSystem(obj) ) 
	    FWObjectClipboard::obj_clipboard->putObject( obj );
    }
}

void  main_window::on_pasteobj()
{
    if ( safe_to_close_right_pane() ) {

	FWObject *obj=FWObjectClipboard::obj_clipboard->getObject();
	if (obj==NULL) return;

	FWObject *cursel=
	    FWObjectDatabase::db->getById( obook->getCurrentSelection() ,true);
	if (cursel==NULL) return;

	pasteTo(cursel,obj);
    }
}

/*
 *  This method does paste into the object tree. Similar operation for
 *  groups is handled by GroupDialog, for policies - by Policydialog and
 *  NATDialog
 */
void main_window::pasteTo(FWObject *target, FWObject *obj)
{
    if ( ( target->getTypeName()==ObjectGroup::TYPENAME ||
	   target->getTypeName()==ServiceGroup::TYPENAME ) &&
	 FWObjectDatabaseGUI::validateObjectForPositionInTree(target, obj) ) {
 
	if ( Resources::isSystem(target) ) {

/*
 *  system groups are different because they hold real objects instead of
 *  references to objects. We need to check if such object already exists 
 *  in the tree and, if not, then add it, but if it does exist, then
 *  create and add its copy
 */

	    FWObject *oo=FWObjectDatabaseGUI::db->getById( obj->getId() , true);
	    FWObject *no=obj;

	    if (oo!=NULL) {
		no=FWObjectDatabaseGUI::db->create(obj->getTypeName());
		assert(no!=NULL);

		no->duplicate(obj);
		no->setName("Copy of "+obj->getName());
	    }

	    FWObjectDatabaseGUI::newObject( target->getId() , no );

	    obook->showPage(0);  // User-defined objects
	    obook->insertObject( no );

	} else {
	    BuiltinDialog *b=getRightPaneDialog();
	    if (b) {
		GroupDialog   *gd=dynamic_cast<GroupDialog*>(b->getDialog());
		if (gd) {
		    gd->addObject(obj);
		}
	    }
	}
    }
/*
    FWObject *no=FWObjectDatabase::db->create(obj->getTypeName());
    assert(no!=NULL);

    if (target->validateChild(no) ) {
	no->duplicate(obj);
	newObject( target->getId() , no );
    } else 
	delete no;
*/
}


void main_window::on_sort()
{
    FWObject *o;
    string id=obook->getCurrentSelection();

    o=FWObjectDatabase::db->getById( id , true ) ;
    assert(o!=NULL);
    o->sortChildren();

    o=FWObjectDatabaseGUI::ScratchPad->getById( id , true ) ;
    assert(o!=NULL);
    o->sortChildren();

//    obook->scheduleRebuildAndShow(id);
    obook->sortSubtree(id);
    OpenObject(id);
}

void main_window::on_find()
{
    if (glademm_get_Widget("FindDialog")==NULL)
	manage(new FindDialog());
}

/*
 *  the following methods emulate user pressing Ctrl-C, Ctrl-X, Ctrl-V
 *  for copy/cut/paste operations. It is not quite right way to
 *  implement clipboard support.  The better way is to scan widgets
 *  tree starting from the main window looking for the widget which
 *  holds focus and is a descendant of the class Editable. If such
 *  widget could be found, we would then use functions
 *  gtk_editable_copy_clipboard etc on it.  We can't use this approach
 *  yet because we heavily use widget Gtk::Table for which children
 *  lists interface is totally broken in gtk-- 1.2 
 *
 *                               --vk 12/15/2001
 */

void  main_window::on_copy()
{
    GdkEvent ev;
    ev.key.window=main_w->get_window();

    ev.key.type=GDK_KEY_PRESS;
    ev.key.state=4;
    ev.key.length=1;
    ev.key.string=NULL;
    ev.key.keyval=GDK_c;            
    Gdk::event_put(ev);
}

void  main_window::on_cut()
{
    GdkEvent ev;
    ev.key.window=main_w->get_window();

    ev.key.type=GDK_KEY_PRESS;
    ev.key.state=4;
    ev.key.length=1;
    ev.key.string=NULL;
    ev.key.keyval=GDK_x;            
    Gdk::event_put(ev);
}

void  main_window::on_paste()
{
    GdkEvent ev;
    ev.key.window=main_w->get_window();

    ev.key.type=GDK_KEY_PRESS;
    ev.key.state=4;
    ev.key.length=1;
    ev.key.string=NULL;
    ev.key.keyval=GDK_v;            
    Gdk::event_put(ev);
}

