/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: ipfwAdvancedDialog.cpp,v 1.6 2004/09/28 05:21:00 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "platforms.h"

#include "ipfwAdvancedDialog.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Management.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qregexp.h>


using namespace std;
using namespace libfwbuilder;


ipfwAdvancedDialog::ipfwAdvancedDialog(QWidget *parent,FWObject *o)
    : ipfwAdvancedDialog_q(parent)
{
    obj=o;

    FWOptions *fwopt=(Firewall::cast(obj))->getOptionsObject();
    assert(fwopt!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    data.registerOption( ipfw_check_shadowing       ,fwopt, "check_shading"   );
    data.registerOption( ipfw_ignore_empty_groups   ,fwopt, "ignore_empty_groups"  );
    data.registerOption( ipfw_fw_dir                ,fwopt, "firewall_dir"    );
    data.registerOption( ipfw_user                  ,fwopt, "admUser"         );
    data.registerOption( altAddress                 ,fwopt, "altAddress"      );
    data.registerOption( activationCmd              ,fwopt, "activationCmd"   );

    data.registerOption( ipfw_manage_virtual_addr   ,fwopt, "manage_virtual_addr"  );
    data.registerOption( ipfw_configure_interfaces  ,fwopt, "configure_interfaces" );
    data.registerOption( ipfw_debug                 ,fwopt, "debug"           );

    data.registerOption( compiler                   ,fwopt, "compiler" );
    data.registerOption( compilerArgs               ,fwopt, "cmdline"  );
    data.registerOption( outputFileName       , fwopt,  "output_file"  );

    data.registerOption( mgmt_ssh             , fwopt,  "mgmt_ssh"  );
    data.registerOption( mgmt_addr            , fwopt,  "mgmt_addr" );

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    installScript->setText(     pis->getCommand().c_str() );
    installScriptArgs->setText( pis->getArguments().c_str() );

    data.loadAll();
}

/*
 * store all data in the object
 */
void ipfwAdvancedDialog::accept()
{
    FWOptions *fwopt=(Firewall::cast(obj))->getOptionsObject();
    assert(fwopt!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    data.saveAll();

    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();
    pis->setCommand( installScript->text().latin1() );
    pis->setArguments( installScriptArgs->text().latin1() );

    ipfwAdvancedDialog_q::accept();
}

void ipfwAdvancedDialog::reject()
{
    ipfwAdvancedDialog_q::reject();
}


