/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 - 2010 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "functions.h"
#include "reread_conf.h"
#include "show_info.h"
#include "apply_user.h"
#include "allocate.h"
#include "populate_users.h"
#include "populate_user_settings.h"
#include "populate_conf_tab.h"


extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_type[1024];

extern int activated;



/* Fixme mod: group, comment and shell */
void apply_user(struct w *widgets)
{
    gchar *info;

    G_CONST_RETURN gchar *username;
    G_CONST_RETURN gchar *groupname;
    G_CONST_RETURN gchar *password;
    G_CONST_RETURN gchar *comment;

    /* Get the settings from the entries */
    username  = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[0]));
    password  = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[1]));
    groupname = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[2]));
    comment   = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[3]));

    /* Make sure we have a valid password */
    if( strlen(password) > 0 && strlen(password) < 6 )
    {
	info = g_strdup_printf(_("The minimum password length is %d.\n"), 6);
	show_info(info);
	g_free(info);
        return;
    }

    password_user(username, password);

    /* Write a client CCD file if the CCD textview contains data */
    write_client_ccd_file(widgets, username);

    /* Populate the user settings */
    populate_user_settings(widgets);

    if( activated )
      reread_conf(widgets);
}
