/* GADMIN-SQUID - An easy to use GTK+ frontend for the Squid proxy server.
 * Copyright (C) 2006 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "populate_acl_tab.h"
#include "create_acl_tab.h"
#include "show_info.h"
#include "commented.h"
#include "functions.h"
#include "get_option_pos.h"

extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];



/* Lists ACL's in the treeviews */
void populate_acl_tab(struct w *widgets)
{
    FILE *fp;
    GtkTreeIter iter;
    GtkTreePath *path;
    gboolean edit = 0;
    char *line, *new_buffer, *new_buffer1;
    long file_size=0, opt_pos=0;
    gchar *utf8=NULL, *info=NULL;

    /* Clear the ACL stores */
    gtk_list_store_clear(widgets->acl_store);
    gtk_list_store_clear(widgets->aclperm_store);

    /* Populate the ACL tab */
    if((fp=fopen(SQUID_CONF, "r"))==NULL)
    {
	/* We just show this popup here too many windows looks bad */
	info = g_strdup_printf("%s %s", _("Error: Cant open squid.conf here:\n"), SQUID_CONF);
        show_info(info);
        g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size+1);
    new_buffer  = allocate(file_size+1);
    new_buffer1 = allocate(file_size+1);

    /* Populate ACLs */
    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
	if( commented(line) )
	  continue;

	/* Populate the contents of the first ACL treeview */
	if( cmplowercase(line, "acl ") )
	{
    	    gtk_list_store_append(GTK_LIST_STORE(widgets->acl_store), &iter);

	    /* Insert ACL Name */
	    sscanf(line, "%*s %s", new_buffer);
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->acl_store), &iter, 0, utf8, -1);

	    /* Insert ACL Type */
	    sscanf(line, "%*s %*s %s %*s", new_buffer);
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->acl_store), &iter, 1, utf8, -1);

	    /* Insert ACL Value */
	    opt_pos = get_option_pos(line, 3);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' )
	      new_buffer[strlen(new_buffer)-1]='\0';

    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->acl_store), &iter, 2, utf8, -1);
	}

	/* Populate the contents of the second ACL treeview */
	if( cmplowercase(line, "http_access ")
	||  cmplowercase(line, "http_reply_access ")
	||  cmplowercase(line, "icp_access ")
	||  cmplowercase(line, "ident_lookup_access ")
	||  cmplowercase(line, "snmp_access ")
	||  cmplowercase(line, "cache ")
	||  cmplowercase(line, "no_cache ")
	||  cmplowercase(line, "always_direct ")
	||  cmplowercase(line, "never_direct ")
	||  cmplowercase(line, "broken_posts ")
	||  cmplowercase(line, "miss_access ")
	||  cmplowercase(line, "follow_x_forwarded_for ")
	||  cmplowercase(line, "broken_vary_encoding ")
	||  cmplowercase(line, "reply_body_max_size ")    )
	{
    	    gtk_list_store_append(GTK_LIST_STORE(widgets->aclperm_store), &iter);

	    /* Some types deviate from the standard so adjust for those.
	       IE: "reply_body_max_size 0 allow AclName" */
	    if( cmplowercase(line, "reply_body_max_size ") )
	    {
		/* Insert ACL Type */
		sscanf(line, "%s %s", new_buffer, new_buffer1);
		strcat(new_buffer, " ");
		strcat(new_buffer, new_buffer1);
    		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
		if( new_buffer[strlen(new_buffer)-1]=='\n' )
	          new_buffer[strlen(new_buffer)-1]='\0';
    		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->aclperm_store), &iter, 0, utf8, -1);

	        /* Insert ACL Permission */
		sscanf(line, "%*s %*s %s", new_buffer);
		/* Convert the first 'a' to 'A' or 'd' to 'D' (Allow/Deny) */
		if( cmplowercase(new_buffer, "a") )
		  new_buffer[0]='A';
		if( cmplowercase(new_buffer, "d") )
		  new_buffer[0]='D';
		
		if( new_buffer[strlen(new_buffer)-1]=='\n' )
	          new_buffer[strlen(new_buffer)-1]='\0';
    		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->aclperm_store), &iter, 1, utf8, -1);

		/* Insert ACL Name */
		opt_pos = get_option_pos(line, 3);
		snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
		if( new_buffer[strlen(new_buffer)-1]=='\n' )
	          new_buffer[strlen(new_buffer)-1]='\0';
    		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->aclperm_store), &iter, 2, utf8, -1);

		continue;	    
	    }

	    /* Regular ACL settings follows... */

	    /* Insert ACL Type */
	    sscanf(line, "%s", new_buffer);
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' )
	      new_buffer[strlen(new_buffer)-1]='\0';
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->aclperm_store), &iter, 0, utf8, -1);

	    /* Insert ACL Permission */
	    sscanf(line, "%*s %s", new_buffer);
	    /* Convert the first 'a' to 'A' or 'd' to 'D' (Allow/Deny) */
	    if( cmplowercase(new_buffer, "a") )
	      new_buffer[0]='A';
	    if( cmplowercase(new_buffer, "d") )
	      new_buffer[0]='D';

	    if( new_buffer[strlen(new_buffer)-1]=='\n' )
	      new_buffer[strlen(new_buffer)-1]='\0';
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->aclperm_store), &iter, 1, utf8, -1);

	    /* Insert ACL Name */
	    opt_pos = get_option_pos(line, 2);
	    snprintf(new_buffer, 1024, "%s", &line[opt_pos]);
	    if( new_buffer[strlen(new_buffer)-1]=='\n' )
	      new_buffer[strlen(new_buffer)-1]='\0';
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->aclperm_store), &iter, 2, utf8, -1);
	}
    }		    
    fclose(fp);
    free(line);
    free(new_buffer);
    free(new_buffer1);

    if( utf8 !=NULL )
      g_free(utf8);

    /* Populate the acl permissions name combo with
       the contents of column 0 of the first acl_treeview */
    populate_aclperm_name_list(GTK_LIST_STORE(widgets->acl_store));


    /* Set treepaths first in the treeviews */
    path = gtk_tree_path_new_first();

    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->acl_treeview), path, NULL, edit);

    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->aclperm_treeview), path, NULL, edit);

    gtk_tree_path_free(path);
}
