/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __mime_h
#define __mime_h

#ifdef __cplusplus
extern "C" {
#endif

void mime_init_defaults (void);
MimeItem* mime_item_get (const gchar *mime_type);
MimeAction mime_get_action (const gchar *mime_type);
void mime_set_action (const gchar *mime_type, MimeAction action);
void mime_item_create (const gchar *mime_type, MimeAction action,
		       const gchar *helperApp, gboolean terminalHelper,
		       gboolean urlHelper, gboolean alwaysUse);
MimeItem *mime_item_clone (MimeItem *m);
void mime_item_free (MimeItem *m);

void mime_db_save (void);
void mime_db_shutdown (void);
void mime_db_load (void);

#ifdef __cplusplus
}
#endif

#endif /* __mime_h */

