/***************************************************************************

  CConst.cpp

  The constants

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __CCONST_CPP


#include "gambas.h"

#include <qnamespace.h>
#include <qframe.h>
#include <qkeysequence.h>

#include "main.h"
#include "CContainer.h"
#include "CConst.h"


GB_DESC CAlignDesc[] =
{
  GB_DECLARE("Align", 0), GB_VIRTUAL_CLASS(),

  GB_CONSTANT("Normal", "i", Qt::AlignVCenter + Qt::AlignAuto),
  GB_CONSTANT("Left", "i", Qt::AlignVCenter + Qt::AlignLeft),
  GB_CONSTANT("Right", "i", Qt::AlignVCenter + Qt::AlignRight),
  GB_CONSTANT("Center", "i", Qt::AlignVCenter + Qt::AlignHCenter),

  GB_CONSTANT("TopNormal", "i", Qt::AlignTop + Qt::AlignAuto),
  GB_CONSTANT("TopLeft", "i", Qt::AlignTop + Qt::AlignLeft),
  GB_CONSTANT("TopRight", "i", Qt::AlignTop + Qt::AlignRight),
  GB_CONSTANT("Top", "i", Qt::AlignTop + Qt::AlignHCenter),

  GB_CONSTANT("BottomNormal", "i", Qt::AlignBottom + Qt::AlignAuto),
  GB_CONSTANT("BottomLeft", "i", Qt::AlignBottom + Qt::AlignLeft),
  GB_CONSTANT("BottomRight", "i", Qt::AlignBottom + Qt::AlignRight),
  GB_CONSTANT("Bottom", "i", Qt::AlignBottom + Qt::AlignHCenter),

  GB_END_DECLARE
};


GB_DESC CArrangeDesc[] =
{
  GB_DECLARE("Arrange", 0), GB_VIRTUAL_CLASS(),

  GB_CONSTANT("None", "i", ARRANGE_NONE),
  GB_CONSTANT("Horizontal", "i", ARRANGE_HORIZONTAL),
  GB_CONSTANT("Vertical", "i", ARRANGE_VERTICAL),
  GB_CONSTANT("LeftRight", "i", ARRANGE_LEFT_RIGHT),
  GB_CONSTANT("TopBottom", "i", ARRANGE_TOP_BOTTOM),
  GB_CONSTANT("Fill", "i", ARRANGE_FILL),

  GB_END_DECLARE
};


GB_DESC CBorderDesc[] =
{
  GB_DECLARE("Border", 0), GB_VIRTUAL_CLASS(),

  GB_CONSTANT("None", "i", BORDER_NONE),
  GB_CONSTANT("Plain", "i", BORDER_PLAIN),
  GB_CONSTANT("Sunken", "i", BORDER_SUNKEN),
  GB_CONSTANT("Raised", "i", BORDER_RAISED),
  GB_CONSTANT("Etched", "i", BORDER_ETCHED),

  GB_END_DECLARE
};


GB_DESC CScrollDesc[] =
{
  GB_DECLARE("Scroll", 0), GB_VIRTUAL_CLASS(),

  GB_CONSTANT("None", "i", 0),
  GB_CONSTANT("Horizontal", "i", 1),
  GB_CONSTANT("Vertical", "i", 2),
  GB_CONSTANT("Both", "i", 3),

  GB_END_DECLARE
};


GB_DESC CLineDesc[] =
{
  GB_DECLARE("Line", 0), GB_VIRTUAL_CLASS(),

  GB_CONSTANT("None", "i", Qt::NoPen),
  GB_CONSTANT("Solid", "i", Qt::SolidLine),
  GB_CONSTANT("Dash", "i", Qt::DashLine),
  GB_CONSTANT("Dot", "i", Qt::DotLine),
  GB_CONSTANT("DashDot", "i", Qt::DashDotLine),
  GB_CONSTANT("DashDotDot", "i", Qt::DashDotDotLine),

  GB_END_DECLARE
};


GB_DESC CFillDesc[] =
{
  GB_DECLARE("Fill", 0), GB_VIRTUAL_CLASS(),

  GB_CONSTANT("None", "i", Qt::NoBrush),
  GB_CONSTANT("Solid", "i", Qt::SolidPattern),
  GB_CONSTANT("Dense94", "i", Qt::Dense1Pattern),
  GB_CONSTANT("Dense88", "i", Qt::Dense2Pattern),
  GB_CONSTANT("Dense63", "i", Qt::Dense3Pattern),
  GB_CONSTANT("Dense50", "i", Qt::Dense4Pattern),
  GB_CONSTANT("Dense37", "i", Qt::Dense5Pattern),
  GB_CONSTANT("Dense12", "i", Qt::Dense6Pattern),
  GB_CONSTANT("Dense6", "i", Qt::Dense7Pattern),
  GB_CONSTANT("Horizontal", "i", Qt::HorPattern),
  GB_CONSTANT("Vertical", "i", Qt::VerPattern),
  GB_CONSTANT("Cross", "i", Qt::CrossPattern),
  GB_CONSTANT("Diagonal", "i", Qt::BDiagPattern),
  GB_CONSTANT("BackDiagonal", "i", Qt::FDiagPattern),
  GB_CONSTANT("CrossDiagonal", "i", Qt::DiagCrossPattern),

  GB_END_DECLARE
};

