/**
 * File:          $RCSfile: pbm_io.h,v $
 * Module:        PBM format image file I/O functions
 * Part of:       Gandalf Library
 *
 * Revision:      $Revision: 1.1 $
 * Last edited:   $Date: 2002/06/05 15:02:14 $
 * Author:        $Author: pm $
 * Copyright:     (c) 2000 Imagineer Software Limited
 */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _GAN_IMAGE_PBM_IO_H
#define _GAN_IMAGE_PBM_IO_H

#include <stdio.h>
#include <gandalf/common/misc_defs.h>
#include <gandalf/image/image_defs.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Prototypes for public functions in pbm_io.c */
Gan_Image *gan_read_pbm_image_stream ( FILE *infile, Gan_Image *image );
Gan_Image *gan_read_pbm_image ( const char *filename, Gan_Image *image );
Gan_Bool   gan_write_pbm_image_stream ( FILE *outfile, Gan_Image *image );
Gan_Bool   gan_write_pbm_image ( const char *filename, Gan_Image *image );

#ifdef __cplusplus
}
#endif

#endif /* #ifndef _GAN_IMAGE_PBM_IO_H */
