/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#define GATOS_CHANNELS_C 1

#include "gatos.h"
#include "channels.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int chan_init(void) {
  int ctr;
  gatos.numchannels = 0;
  for(ctr=0; ctr<MAX_CHANNELS; ctr++) {
    gatos.channelinfo[ctr].frequency = 0.0;
    gatos.channelinfo[ctr].name[0] = 0;
    gatos.channelinfo[ctr].mod_volume = 0;
    gatos.channelinfo[ctr].mod_brightness = 0;
    gatos.channelinfo[ctr].mod_saturation = 0;
    gatos.channelinfo[ctr].mod_contrast = 0;
    gatos.channelinfo[ctr].mod_hue = 0;
    }
  return 0 ; }

void chan_clearchans() {
  gatos.numchannels=0;
  }

void chan_delchan(int c) {
  int ctr;
  gatos.numchannels--;
  for(ctr=c; ctr<gatos.numchannels; ctr++) {
    gatos.channelinfo[ctr] = gatos.channelinfo[ctr+1];
    }
  }

int chan_addchan(double f, char *n) {
  if(gatos.numchannels >= MAX_CHANNELS) {
    /* Fixme: Proper Error!! */
    printf("Channel overflow!\n");
    exit(1);
    }
  gatos.channelinfo[gatos.numchannels].frequency = f;
  snprintf(gatos.channelinfo[gatos.numchannels].name,
    sizeof(gatos.channelinfo[gatos.numchannels].name), "%s", n);
  if(CHANNELMGMT)
    printf("Added channel %d (%f), \"%s\"\n", gatos.numchannels, f, n);
  return gatos.numchannels++;
  }

int chan_setname(int c, char *n) {
  snprintf(gatos.channelinfo[c].name,sizeof(gatos.channelinfo[c].name),
    "%s", n);
  return 0;
  }

char *chan_name(int c) {
  return gatos.channelinfo[c].name;
  }

double chan_setfreq(int c, double f) {
  gatos.channelinfo[c].frequency = f;
  if(c==gatos.channel) gatos_settuner(gatos.channelinfo[c].frequency);
  return gatos.channelinfo[c].frequency;
  }

double chan_freq(int c) {
  return gatos.channelinfo[c].frequency;
  }

int chan_volume(int c) {
  return gatos.channelinfo[c].mod_volume;
  }

int chan_setvolume(int c, int v) {
  gatos.channelinfo[c].mod_volume = v;
  if(c==gatos.channel) gatos_setvolume(gatos.volume);
  return 0;
  }

int chan_brightness(int c) {
  return gatos.channelinfo[c].mod_brightness;
  }

int chan_setbrightness(int c, int v) {
  gatos.channelinfo[c].mod_brightness = v;
  if(c==gatos.channel) gatos_setbrightness(gatos.brightness);
  return 0;
  }

int chan_contrast(int c) {
  return gatos.channelinfo[c].mod_contrast;
  }

int chan_setcontrast(int c, int v) {
  gatos.channelinfo[c].mod_contrast = v;
  if(c==gatos.channel) gatos_setcontrast(gatos.contrast);
  return 0;
  }

int chan_hue(int c) {
  return gatos.channelinfo[c].mod_hue;
  }

int chan_sethue(int c, int v) {
  gatos.channelinfo[c].mod_hue = v;
  if(c==gatos.channel) gatos_sethue(gatos.hue);
  return 0;
  }

int chan_saturation(int c) {
  return gatos.channelinfo[c].mod_saturation;
  }

int chan_setsaturation(int c, int v) {
  gatos.channelinfo[c].mod_saturation = v;
  if(c==gatos.channel) gatos_setsaturation(gatos.saturation);
  return 0;
  }

