/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include <ibtk/version.h>
#include <ibtk/iwindow.h>
#include <ibtk/ibox.h>
#include <ibtk/itextbox.h>
#include <ibtk/istatbar.h>
#include <ibtk/ibutton.h>
#include <ibtk/isbutton.h>
#include <ibtk/islider.h>
#include <ibtk/iintbox.h>
#include <ibtk/irealbox.h>
#include <ibtk/ilistbox.h>

#ifdef USE_DGA
#include <X11/extensions/xf86dga.h>
#define private pprivate
#include <X11/extensions/xf86vmode.h>
XF86VidModeModeInfo oldv;
#endif

#include "gatos.h"
#include "cc.h"
#include "xutils.h"

static IWindow *mwin = NULL;
static Window icon;
static IButton *aguib=NULL, *captguib=NULL, *chguib=NULL;
static IButton *setupb=NULL;
static ISButton *inp1=NULL, *inp2=NULL, *inp3=NULL;
static ISButton *coldb=NULL, *muteb=NULL, *stereob=NULL, *sapb=NULL;
static ISButton *fullb=NULL, *deskb=NULL, *topb=NULL, *senscb=NULL;
static IListBox *CCl=NULL;
static IIntBox *dotb=NULL, *ahb=NULL;
static ITextBox *dotl=NULL, *CCb=NULL;
static ISButton *ahl=NULL, *CCt=NULL;
#ifdef USE_DGA
static ISButton *dgab=NULL;
#endif
static ISlider *gammas=NULL;
static IRealBox *freq=NULL;
static ISlider *svol=NULL, *sbr=NULL, *scnt=NULL, *shue=NULL, *ssat=NULL;
static ISlider *cvol=NULL, *cbr=NULL, *ccnt=NULL, *chue=NULL, *csat=NULL;
static IButton *scanb=NULL, *cadd=NULL, *crem=NULL, *creset=NULL;
static IRealBox *cfreq=NULL;
static IBox *nameb=NULL, *chnb=NULL;
static IIntBox *chnum=NULL;
static IButton *snapb=NULL, *recb=NULL, *stopb=NULL, *playb=NULL, *clearb=NULL;
static IIntBox *xcaptb=NULL, *ycaptb=NULL;
static IBox *captfl=NULL;

static IListBox *formb=NULL, *mixerb=NULL;
static ITextBox *forml=NULL, *optl=NULL, *mixl=NULL;
static ISButton *svszb=NULL, *farb=NULL;
static IButton *rescanb=NULL, *doneb=NULL;

static ITextBox *csitp1=NULL, *csitb1=NULL, *csitp2=NULL, *csitb2=NULL;
static IStatBar *csisb=NULL;
static IButton *cscan=NULL;

#ifdef GATOSBUTTONS
static IIntBox *testb[GATOSBUTTONS];
static ITextBox *testl[GATOSBUTTONS];
#endif

#define MAXGUI		3
#define NUM_FORMATS	11

static int format_nums[NUM_FORMATS] = { 1, 2, 3, 3, 3, 3, 3, 4, 5, 6, 7 };
static char *format_names[NUM_FORMATS] = { // "Undefined!",
	"NTSC-M      US and many others",
	"NTSC-Japan  Japan",
	"PAL-B       Many (Europe)",
	"PAL-D       China",
	"PAL-G       Many (Europe)",
	"PAL-H       Belgium",
	"PAL-I       Great Britain and others",
	"PAL-M       Brazil (NTSC-like PAL format)",
	"PAL-N       Paraguay, Uruguay",
	"SECAM       East Europe, France, Middle East",
	"PAL-Ncomb   Argentina" };

static int autohide=200, useautohide=200;
static int full=0, usedesk=0, sdesk=0, mapped=0, ontop=0;
static int oldxp=0, oldyp=0, oldx=0, oldy=0, tmpfar;
static int advgui=0, captgui=0, changui=0, setupgui=0, show=1;
static int ixs, iys, svsz=1, far=1, lasttime;
static int prevch, favch[8]={-1,-1,-1,-1,-1,-1,-1,-1};
static int ccmode=CC_MODE_CC1;
static int paused=0;
static time_t ltime=0;

static struct timeval timeout;
static int useCC=0;

#ifdef USE_DGA
  char *frame; int rowlen, bank, mem, depth, ctrx, ctry;
  static int usedga=0;
#endif


PALETTE pal;

XImage *message=NULL;
char *lastmessage=NULL;
long lastmessagesize=-1;
long lastmessage_x=-1,lastmessage_y=-1;
long message_x=10,message_y=5;
long messageon=0;
// int message_turn_gui_on=0; // Don't want to Hide old GUI.

XImage *channel=NULL;
char *lastchannel=NULL;
long lastchannelsize=-1;
long lastchannel_x=-1,lastchannel_y=-1;
long channel_x=10,channel_y=5;
long channelon=0;


#define FIRST_MODE		0
#define MODE_VOLUME 		0
#define MODE_BRIGHTNESS 	1
#define MODE_CONTRAST  		2
#define MODE_INPUT_SOURCE	3
#define MODE_CC			4
#define MODE_SAP		5
#define LAST_MODE		5
#define FREE_MODE		(LAST_MODE+1)

int message_mode=MODE_VOLUME;

char *mode_name[]={
		"Volume",
		"Brightness",
		"Contrast",
		"Input",
		"Caption",
		"Sap" };
		

long cctexton=0;

int transparent_letters=-1;
long cctext_x=10,cctext_y=50;
long cctext_width=1,cctext_height=1;
int cctext_repaint=1;

static long slideron=0; /* tells whether the slider has been drawn */
static long slider_timeout=180;
long slider_x=0,slider_y=0;

void toggleshow(void);
void initgui(void);
void updategui(void);
void updatechgui(void);
void ActivityCB(IWindow *w);
void ExposeCB(IWindow *w);
void ResizeCB(IWindow *w, int x, int y);
void RepositionCB(IWindow *w, int x, int y);
void OtherEventCB(IWindow *w, XEvent *ev);
void ClickCB(IWindow *w, int, int, int);
void chchan(IDoDad *p, IDoDad *d);
void snapcb(IDoDad *p, IDoDad *d, int);
void reccb(IDoDad *p, IDoDad *d, int);
void playcb(IDoDad *p, IDoDad *d, int);
void stopcb(IDoDad *p, IDoDad *d, int);
void clearcb(IDoDad *p, IDoDad *d, int);
void chcfreq(IDoDad *p, IDoDad *d);
void chfreq(IDoDad *p, IDoDad *d);
void cremcb(IDoDad *p, IDoDad *d, int);
void caddcb(IDoDad *p, IDoDad *d, int);
void cresetcb(IDoDad *p, IDoDad *d, int);
void loadstate(void);
void savestate(void);
void UP_CB(void);
void DOWN_CB(void);
void LEFT_CB(void);
void RIGHT_CB(void);
void deskCB(IDoDad *p, IDoDad *d, int x);
void CCtCB(IDoDad *p, IDoDad *d, int x);
void CCCB(IDoDad *p, IDoDad *d, int x);
void ShowMessage(char *);
void ShowChannel(char *);
void ShowControl(void);
void EraseMessage(void);
void EraseChannel(void);
void ShowCCStrings(void);
void EraseCCStrings(void);
void ShowCCText(void);
void EraseCCText(void);
void UniDrawRectangle(int x, int y,int width, int height, long color);
void DrawSlider(long value,long maxvalue,int erase);
void fullCB(IDoDad *p, IDoDad *d, int x);
void dotCB(IDoDad *p, IDoDad *d);
void ahCB(IDoDad *p, IDoDad *d);
void ahlCB(IDoDad *p, IDoDad *d, int x);
void senscCB(IDoDad *p, IDoDad *d, int x);
#ifdef USE_DGA
void dgaCB(IDoDad *p, IDoDad *d, int x);
#endif
void ResetAutoHide();

#ifdef CC_CURSES
#include "ccshow.h"
#endif

void hookfn(void) {
  if(usedesk && sdesk) {
    XSetForeground(mwin->GetDisplay(), mwin->GetGC(), mwin->GetWinBGColor());
    XFillRectangle(mwin->GetDisplay(), mwin->GetRootWindow(), mwin->GetGC(),
	0, 0, mwin->XDeskSize(), mwin->YDeskSize());
    }
  if(useautohide && show) {
    if(autohide) {
      --autohide;
      if(show && (!autohide)) { toggleshow(); XFlush(mwin->GetDisplay()); }
      }
    }
  if(useCC) { 
  	cc_hook(); 
#ifdef CC_CURSES
	cc_show();
#else
	ShowCCText();XFlush(mwin->GetDisplay());
#endif
	}
  if(slideron>1)slideron--;
  if(slideron==1){
  		DrawSlider(100,100,1);XFlush(mwin->GetDisplay());
		slideron=0;
		}
  if(channelon>1)channelon--;
  if(channelon==1){
  		EraseChannel();XFlush(mwin->GetDisplay());		
		channelon=0;
		}
  if(messageon>1)messageon--;
  if(messageon==1){
  		EraseMessage();XFlush(mwin->GetDisplay());		
		messageon=0;

// Don't want to hide old GUI - ISG
//		if(message_turn_gui_on){
//			if(!show)toggleshow();
//			message_turn_gui_on=0;
//			XFlush(mwin->GetDisplay());
//			}
		}
#ifndef CC_CURSES
  if(cctexton>1)cctexton--;
  if(cctexton==1){
  		/* EraseCCText();XFlush(mwin->GetDisplay()); */
		cctexton=0;
		}
#endif
  }

int main(int argc, char **argv) {
  int i, verb = 0;
  for ( i=1; i<argc; i++ ) {
    if (!strcmp(argv[i],"-nosa")) gatos_setnosa(1) ; /* For testing /AA */
    else if (!strcmp(argv[i],"-pci") && i+1<argc) {
      i++ ; gatos_setpci(argv[i]); /* Override pciaddr in gatos.conf */
      }
    else if (!strcmp(argv[i],"-q"))    verb |= GATOSQUIET;
    else if (!strcmp(argv[i],"-v"))    verb |= 1;
    else if (!strcmp(argv[i],"-qv"))   verb |= 1|GATOSQUIET;
    else if (!strcmp(argv[i],"-vq"))   verb |= 1|GATOSQUIET;
    else if (!strncmp(argv[i],"-d",2)) verb |= atoi(argv[i]+2);
    }

  mwin = new IWindow("XATITV-GATOS", "#102030", &icon, 96, 72);

#ifdef USE_DGA
  XF86DGAGetVideo(mwin->GetDisplay(), 0, (char**)&frame, &rowlen, &bank, &mem);
#endif

  gatos_setverbosity(verb);
  if(VERBOSE) fprintf(stderr, "IBTK version %s\n", IBTK_VERSION_STRING);
  if(gatos_init()) { perror("xatitv: gatos_init()"); exit(1); }
  ixs=gatos_xcapt(); iys=gatos_ycapt(); prevch=gatos_channel(); loadstate();

  mwin->SetBufSize(640, 480); // This IS correct, even for PAL  --ISG
  mwin->Map(ixs, iys);
  mwin->SetUnhandledCallback(OtherEventCB);
  mwin->SetClickCallback(ClickCB);
  mwin->SetResizeCallback(ResizeCB);
  mwin->SetRepositionCallback(RepositionCB);
  mwin->SetExposeCallback(ExposeCB);
  mwin->SetActivityCallback(ActivityCB);
  initgui();

  if(gatos_setcolorkey(mwin->GetWinBGColor()))
    { perror("xatitv: gatos_setcolorkey()"); exit(1); }
  gatos_enable_sound(1);
  gatos_enable_video(1);
  gatos_enable_capture(1);
/*
  createProtoImage(mwin->GetDisplay(),mwin->GetWindow());
  fillPalette(mwin->GetDisplay(),mwin->GetWindow(),mwin->GetGC(),&pal);
*/
  if(show) { show=0; toggleshow(); }
  timeout.tv_sec=0;
  timeout.tv_usec=33000; /* 33 ms = one frame at for 60 HZ fields*/
  mwin->RegisterHook(&hookfn,&timeout);
  mwin->DispatchEvents();
  if(full) fullCB(fullb, fullb, 0);
  if(useautohide && (!autohide) && (!show))
	{ toggleshow(); XFlush(mwin->GetDisplay()); }
  savestate();  
  /* change 0 to 1 to get printout about hash effectiveness */
#if 0  
 print_xutils_stats(); 
#endif 
#ifdef CC_CURSES
  cc_mode(-1); 
#endif
  gatos_terminate();
  }

void chname(IDoDad *p, IDoDad *d)  {
  int start=-1, ctr, done=0, len = strlen(nameb->GetText());
  if(len < 1) return;
  if(!strncasecmp(nameb->GetText(), gatos_channame(gatos_channel()), len)) {
    nameb->SetChangeCallback(NULL);
    nameb->SetText(chnb->GetText());
    nameb->SetCurPos(nameb->CurPos(), strlen(nameb->GetText()));
    nameb->SetChangeCallback(chname);
    nameb->Redraw();
    return;
    }
  for(ctr=0; done==0 && ctr<gatos_numchans(); ctr++) {
    if(!strncasecmp(nameb->GetText(), gatos_channame(ctr), len)) done=1;
//    if(done) printf("\"%s\" == \"%s\"\n", nameb->GetText(), gatos_channame(ctr));
//    else printf("\"%s\" != \"%s\"\n", nameb->GetText(), gatos_channame(ctr));
    }
  if(nameb->CurPos() == (int)strlen(nameb->GetText())) start=nameb->CurPos();
  if(done!=0) {
    chnum->SetVal(ctr);
    chnum->Redraw();
    if(start>=0) {
      nameb->SetCurPos(start, strlen(nameb->GetText()));
      }
    }
  }

void chdesc(IDoDad *p, IDoDad *d)  {
  if(gatos_mux()!=2) return;
  gatos_setchanname(gatos_channel(), ((IBox *)d)->GetText());
  }

void updatetextbox() {
  if(chnb == NULL) return;
  chnb->SetChangeCallback(NULL);
  if(gatos_mux()==2 && gatos_numchans()<1) {
    chnb->Disable(); chnum->Disable(); nameb->Disable();
    return;
    }
  chnb->Enable(); chnum->Enable(); nameb->Enable();
  if(gatos_mux()==2) chnb->SetText(gatos_channame(gatos_channel()));
  else if(gatos_mux()==0 || gatos_mux()==3) chnb->SetText("S-Video Input");
  else if(gatos_mux()==1) chnb->SetText("Composite-Video Input");
  else chnb->SetText("Not Connected");
  chnb->SetChangeCallback(chdesc);
  chnb->Redraw();
  nameb->SetChangeCallback(NULL);
  nameb->SetText(chnb->GetText());
  nameb->SetChangeCallback(chname);
  nameb->Redraw();
  char buf[256];
  sprintf(buf, "XATITV-GATOS: %s%c", chnb->GetText(), 0);
  mwin->SetTitle(buf);
  }

void visibility(XVisibilityEvent &e) {
  if(ontop && e.state) XRaiseWindow(mwin->GetDisplay(), mwin->GetWindow());
  gatos_setvisibility(e.state);
  cctext_repaint=1; 
  }

void keypress(XKeyEvent &e) {
  switch(XKeycodeToKeysym(mwin->GetDisplay(), e.keycode, 0)) {
    case(XK_KP_Multiply): fullb->Press(0,0,0); break;
    case(XK_KP_Enter):
    case(XK_Return): ltime=0; mwin->TakeFocus(NULL); break;
    case(XK_KP_Divide): muteb->Press(0,0,0); break;
    case(XK_quoteleft): CCt->Press(0,0,0); break;
//    case(XK_less): case(XK_comma):
//	mwin->Resize(mwin->XSize()/2, mwin->YSize()/2); break;
//    case(XK_greater): case(XK_period):
//	mwin->Resize(2*mwin->XSize(), 2*mwin->YSize()); break;
    case(XK_Print):
	snapcb(NULL, snapb, 0);
    	break;
    case(XK_Pause):
	gatos_enable_capture(paused);
	paused = !paused;
    	break;
    case(XK_Tab):
    	toggleshow(); 
    	break;
    case(XK_Up): 
    	UP_CB();
	break;
    case(XK_Down): 
        DOWN_CB();
	break;
    case(XK_Right): RIGHT_CB();
      break;
    case(XK_Left): LEFT_CB();
      break;
    case(XK_Escape): mwin->Close(); break;
    case(XK_KP_Add): chnum->SetVal(chnum->GetVal()+1); chnum->Redraw(); break;
    case(XK_KP_Subtract): chnum->SetVal(chnum->GetVal()-1); chnum->Redraw(); break;
    case(XK_F1): {
      if(e.state&ControlMask) favch[0]=gatos_channel();
      else if(favch[0]>=0) { chnum->SetVal(favch[0]+1); chnum->Redraw(); }
      }break;
    case(XK_F2): {
      if(e.state&ControlMask) favch[1]=gatos_channel();
      else if(favch[1]>=0) { chnum->SetVal(favch[1]+1); chnum->Redraw(); }
      }break;
    case(XK_F3): {
      if(e.state&ControlMask) favch[2]=gatos_channel();
      else if(favch[2]>=0) { chnum->SetVal(favch[2]+1); chnum->Redraw(); }
      }break;
    case(XK_F4): {
      if(e.state&ControlMask) favch[3]=gatos_channel();
      else if(favch[3]>=0) { chnum->SetVal(favch[3]+1); chnum->Redraw(); }
      }break;
    case(XK_F5): {
      if(e.state&ControlMask) favch[4]=gatos_channel();
      else if(favch[4]>=0) { chnum->SetVal(favch[4]+1); chnum->Redraw(); }
      }break;
    case(XK_F6): {
      if(e.state&ControlMask) favch[5]=gatos_channel();
      else if(favch[5]>=0) { chnum->SetVal(favch[5]+1); chnum->Redraw(); }
      }break;
    case(XK_F7): {
      if(e.state&ControlMask) favch[6]=gatos_channel();
      else if(favch[6]>=0) { chnum->SetVal(favch[6]+1); chnum->Redraw(); }
      }break;
    case(XK_F8): {
      if(e.state&ControlMask) favch[7]=gatos_channel();
      else if(favch[7]>=0) { chnum->SetVal(favch[7]+1); chnum->Redraw(); }
      }break;

    case(XK_F9): gatos_debug1(); break;
    case(XK_F10): gatos_debug2(); break;
    case(XK_F11): gatos_debug3(); break;
    case(XK_F12): gatos_debug4(); break;
    case(XK_BackSpace): {
      int tmpc = gatos_channel();
      chnum->SetVal(prevch+1);
      prevch = tmpc;
      chnum->Redraw(); break;
      }
    default: {
      KeySym key; char buf[256];
      int len = XLookupString(&e,buf,sizeof(buf),&key,NULL) ;
      buf[len] = 0;
      if(buf[0] != 0 && buf[1] == 0) {
	switch(buf[0]) {
	  case('0'): case('1'): case('2'): case('3'): case('4'): 
	  case('5'): case('6'): case('7'): case('8'): case('9'): {
	    time_t ttime = time(NULL);
	    if(ttime < ltime+2) {
	      int v = (chnum->GetVal() * 10) + buf[0] - '0';
	      if(gatos_numchans() > 99 && v > gatos_numchans()) v %= 1000;
	      else if(gatos_numchans() > 9 && v > gatos_numchans()) v %= 100;
	      else if(v > gatos_numchans()) v %= 10;
	      if(v > gatos_numchans()) v = gatos_numchans();
	      else if(v < 1) v = 1;
	      chnum->SetVal(v);
	      }
	    else {
	      chnum->SetVal(buf[0] - '0');
	      }
	    ltime = ttime;
//	    mwin->TakeFocus(chnum); chnum->Press(1,9,0); chnum->Redraw();
	    }break;
	  case('<'): mwin->Resize(mwin->XSize()/2, mwin->YSize()/2); break;
	  case('>'): mwin->Resize(2*mwin->XSize(), 2*mwin->YSize()); break;
	  case(','): mwin->Resize(mwin->XSize()/2, mwin->YSize()/2); break;
	  case('.'): mwin->Resize(2*mwin->XSize(), 2*mwin->YSize()); break;
	  case('/'): muteb->Press(0,0,0); break;
	  default: {
	    if(show && (!setupgui)) {
	      nameb->SetCurPos(0, strlen(nameb->GetText())); nameb->KeyDown(e);
	      mwin->TakeFocus(nameb); nameb->Redraw();
	      }
	    }break;
	  }
	}
//      else printf("Pressed %.4X\n", XKeycodeToKeysym(mwin->GetDisplay(), e.keycode, 0));
      }
    }
  }

void DOWN_CB(void)
{
if(messageon){
	message_mode--;
	if(message_mode<FIRST_MODE)message_mode=LAST_MODE;
	}
ShowControl();
}

void UP_CB(void)
{
if(messageon){
	message_mode++;
	if(message_mode>LAST_MODE)message_mode=FIRST_MODE;
	}
ShowControl();
}

void RIGHT_CB(void)
{

if(messageon)switch(message_mode){
	case MODE_VOLUME:
		svol->SetValue(svol->Value()+1); 
		break;
        case MODE_BRIGHTNESS:
		if(sbr->Value()<sbr->Max())sbr->SetValue(sbr->Value()+1);
		break;
        case MODE_CONTRAST:
		if(scnt->Value()<scnt->Max())scnt->SetValue(scnt->Value()+1);
		break;
	case MODE_INPUT_SOURCE:
		if(gatos_mux() == 3 || gatos_mux() == 0){
				 inp3->Press(0,0,0);
				 }
			else if(gatos_mux() == 1){
				 inp1->Press(0,0,0);
				 }
	      		else {
				inp2->Press(0,0,0);
				}
		break;
	case MODE_CC:
		if(!useCC)ccmode=-1;
                ccmode++;
		if(ccmode>=4)ccmode=-1;
//                CCCB(NULL,NULL,ccmode);
		if(ccmode==-1 && CCt->State()) CCt->Press(0,0,0);
		else if(ccmode>=0 && (!CCt->State())) CCt->Press(0,0,0);
                if(ccmode>=0) CCl->Select(ccmode);
		break;
	case MODE_SAP:
		sapb->Press(0,0,0);
		break;
	default:
		break;
		}
ShowControl();		
}

void LEFT_CB(void)
{

if(messageon)switch(message_mode){
	case MODE_VOLUME:
		svol->SetValue(svol->Value()-1); 
		break;
        case MODE_BRIGHTNESS:
		if(sbr->Value()>sbr->Min())sbr->SetValue(sbr->Value()-1);
		break;
        case MODE_CONTRAST:
		if(scnt->Value()>scnt->Min())scnt->SetValue(scnt->Value()-1);
		break;
	case MODE_INPUT_SOURCE:
		if(gatos_mux() == 3 || gatos_mux() == 0){
				inp2->Press(0,0,0);
				}
      			else if(gatos_mux() == 1) {
				inp3->Press(0,0,0);
				}
      			else {
				inp1->Press(0,0,0);
				}
		break;
	case MODE_CC:
		if(!useCC)ccmode=-1;
		ccmode--;
		if(ccmode<-1)ccmode=3;
//                CCCB(NULL,NULL,ccmode);
		if(ccmode==-1 && CCt->State()) CCt->Press(0,0,0);
		else if(ccmode>=0 && (!CCt->State())) CCt->Press(0,0,0);
                if(ccmode>=0) CCl->Select(ccmode);
		break;
	case MODE_SAP:
		stereob->Press(0,0,0);
		break;
	default:
		break;
		}
ShowControl();		
}

void ClickCB(IWindow *w, int b, int x, int y) {
  if(b>1) toggleshow();
  ResetAutoHide();
  }

void ResetAutoHide() {
  if(useautohide) {
    if((!show) && (!autohide)) toggleshow();
    autohide = useautohide;
    }
  }

void OtherEventCB(IWindow *w, XEvent *ev) {
  switch (ev->type) {
    case KeyPress: keypress(ev->xkey); break;
    case MapNotify: {
      mwin->Redraw(); mwin->RebuildClip(); cctext_repaint=1; ShowCCText();
      if(!mapped) createProtoImage(mwin->GetDisplay(),mwin->GetWindow());
      if(!mapped) fillPalette(mwin->GetDisplay(),mwin->GetWindow(),mwin->GetGC(),&pal);
      if(!mapped && (transparent_letters<0)) {
      		if(get_actual_depth()==8)transparent_letters=0;
			else transparent_letters=1;
		}
      gatos_setgeometry(w->XSize(), w->YSize(), w->XPos(), w->YPos());
      gatos_setmapped(1); mapped=1;
      if(usedesk) {
	XClearWindow(mwin->GetDisplay(), mwin->GetRootWindow());
	sdesk=0;
	}
      cctext_repaint=1;
      }
      break;
    case UnmapNotify: {
      if(!usedesk) { gatos_setmapped(0); mapped=0; }
      else {
	XSetForeground(mwin->GetDisplay(), mwin->GetGC(), mwin->GetWinBGColor());
	XFillRectangle(mwin->GetDisplay(), mwin->GetRootWindow(), mwin->GetGC(),
		0, 0, mwin->XDeskSize(), mwin->YDeskSize());
	gatos_setgeometry(mwin->XDeskSize(), mwin->YDeskSize(), 0, 0);
	sdesk=1;
	}
      }break;
    case VisibilityNotify: visibility(ev->xvisibility); break;
/*
    default: {
      if(desk && (!mapped)) {
	XSetForeground(mwin->GetDisplay(), mwin->GetGC(), mwin->GetWinBGColor());
	XFillRectangle(mwin->GetDisplay(), mwin->GetRootWindow(), mwin->GetGC(),
		0, 0, mwin->XDeskSize(), mwin->YDeskSize());
	gatos_setgeometry(mwin->XDeskSize(), mwin->YDeskSize(), 0, 0);
	}
      }break;
*/
    }
  }

void ExposeCB(IWindow *w) {
  /*gatos_setgeometry(w->XSize(), w->YSize(), w->XPos(), w->YPos()); /AA */
  }

void ActivityCB(IWindow *w) {
  ResetAutoHide();
  }

void ResizeCB(IWindow *w, int x, int y) {
  if(usedesk && !mapped) return;
  if(far) {
    int xs=x, ys=y;
    if (xs != gatos.xsize && ys != gatos.ysize) {
      if (ys > (xs*gatos_ycaptmax())/gatos_xcaptmax())
        ys = (xs*gatos_ycaptmax())/gatos_xcaptmax();
      else
        xs = (ys*gatos_xcaptmax())/gatos_ycaptmax();
      }
    else if (xs != gatos.xsize) {
      ys = (xs*gatos_ycaptmax())/gatos_xcaptmax();
      }
    else if (ys != gatos.ysize) {
      xs = (ys*gatos_xcaptmax())/gatos_ycaptmax();
      }
    if (xs != x || ys != y) mwin->Resize(xs, ys);
    }
  else gatos_setgeometry(w->XSize(), w->YSize(), w->XPos(), w->YPos());
  mwin->RebuildClip();
  }

void RepositionCB(IWindow *w, int x, int y) {
  if(usedesk && !mapped) return;
  gatos_setgeometry(w->XSize(), w->YSize(), w->XPos(), w->YPos());
  }

void inp(IDoDad *p, IDoDad *d, int x)  {
  int omux = gatos_mux();
  if(d == inp1) { gatos_setmux(3); if(chnum!=NULL) chnum->Disable(); }
  else if(d == inp2) { gatos_setmux(1); if(chnum!=NULL) chnum->Disable(); }
  else if(d == inp3) { gatos_setmux(2); if(chnum!=NULL) {
	chnum->Enable(); chchan(NULL, chnum); } }
  else {
    fprintf(stderr, "Bad ButtonPress!\n");
    exit(1);
    }
  if(d != inp1 && inp1->State() == 1) inp1->Press(1, 0, 0);
  if(d != inp2 && inp2->State() == 1) inp2->Press(1, 0, 0);
  if(d != inp3 && inp3->State() == 1) inp3->Press(1, 0, 0);
  updatetextbox();
  if(omux != gatos_mux()) cc_reset();
  }

void chcapt(IDoDad *p, IDoDad *d) {
  gatos_setcapturesize(xcaptb->GetVal(), ycaptb->GetVal());
  }

void chfreq(IDoDad *p, IDoDad *d) {
  gatos_settuner(((IRealBox *)d)->GetVal());
  }

void chcfreq(IDoDad *p, IDoDad *d) {
  gatos_setchanfreq(gatos_channel(), ((IRealBox *)d)->GetVal());
  }

void csld(IDoDad *p, IDoDad *d, int x)  {
  if(d == cvol) gatos_setchanvolume(gatos_channel(), x);
  else if(d == cbr) gatos_setchanbrightness(gatos_channel(), x);
  else if(d == ccnt) gatos_setchancontrast(gatos_channel(), x);
  else if(d == chue) gatos_setchanhue(gatos_channel(), x);
  else if(d == csat) gatos_setchansaturation(gatos_channel(), x);
  else {
    fprintf(stderr, "Bad Slider Pressed!\n");
    exit(1);
    }
  }

void sld(IDoDad *p, IDoDad *d, int x)  {
  if(d == svol) gatos_setvolume(x);
  else if(d == sbr) gatos_setbrightness(x);
  else if(d == scnt) gatos_setcontrast(x);
  else if(d == shue) gatos_sethue(x);
  else if(d == ssat) gatos_setsaturation(x);
  else if(d == gammas) gatos_setgamma(x);
  else {
    fprintf(stderr, "Bad Slider Pressed!\n");
    exit(1);
    }
  }

#ifdef USE_DGA
void dgaCB(IDoDad *p, IDoDad *d, int x)  {
  if(full) { int tmpd=usedesk; usedesk=0; fullb->Press(0,0,0); usedesk=tmpd; }
  usedga=x;
  }
#endif

void senscCB(IDoDad *p, IDoDad *d, int x)  {
  gatos_setsenscan(x);
  }

void ahlCB(IDoDad *p, IDoDad *d, int x)  {
  if(!x) {
    ahb->Disable();
    useautohide = 0;
    }
  else {
    useautohide = (((IIntBox*)ahb)->GetVal())*100;
    ahb->Enable();
    if(ahb->GetVal() <= 0) ahb->SetVal(1);
    }
  }

void ahCB(IDoDad *p, IDoDad *d)  {
  useautohide = (((IIntBox*)d)->GetVal())*100;
  autohide = useautohide;
  if((!useautohide) && (ahl->State())) ahl->Press(0,0,0);
  }

void dotCB(IDoDad *p, IDoDad *d)  {
  gatos_setoverclock(((IIntBox*)d)->GetVal());
  }

#ifdef GATOSBUTTONS
void testCB(IDoDad *p, IDoDad *d)  {
  int which;
  for(which=0; which<GATOSBUTTONS && d != testb[which]; ++which)
  if(which >= GATOSBUTTONS)  {
    fprintf(stderr, "Bad Testbutton Pressed!\n");
    exit(-1);
    }
  gatos_settestbutton(which, ((IIntBox*)d)->GetVal());
  }
#endif

void deskCB(IDoDad *p, IDoDad *d, int x)  {
  usedesk=x;
  if(usedesk) mwin->DisableIcon();
  else mwin->EnableIcon();
  }

void CCtCB(IDoDad *p, IDoDad *d, int x)  {
  CCCB(p, CCl, x?ccmode:-1);
  }

void CCCB(IDoDad *p, IDoDad *d, int x)  {
  x+=1; if(!CCt->State()) x=0;
  if((!useCC) && x) {
    useCC=1;
    ccmode=x-1;
    if(gatos_setCC(GET_CC|GET_EDS)) { useCC=0; ccmode=-1;}
    else { 
#ifdef CC_CURSES
      cc_mode(ccmode);
#else
	EraseCCText();XFlush(mwin->GetDisplay());
#endif
      cc_reset(); 
      }
    }
  else if (x) {
    ccmode=x-1;
#ifdef CC_CURSES
      cc_mode(ccmode);
#else
        EraseCCText();XFlush(mwin->GetDisplay());
        cctext_repaint=1;
        ShowCCText();
#endif
    }
  else {
    useCC=0; gatos_setCC(0);
#ifdef CC_CURSES
    cc_mode(-1);
#else
	EraseCCText();XFlush(mwin->GetDisplay());
#endif
    }
  }

void topCB(IDoDad *p, IDoDad *d, int x)  {
  ontop=x;
  }

void EraseChannel(void)
{
if(channel==NULL)return;
UniDrawRectangle(channel_x,channel_y,channel->width,channel->height,
				gatos_colorkey());
XFreeImage(channel);
channel=NULL;				
}


void ShowChannel(char *string)
{
int size,window_x;
// Don't want to hide old GUI. -ISG
//if(show){
//	toggleshow();
//	channel_turn_gui_on=1;
//	}

#ifdef USE_DGA
if(usedga && full){
	size=gatos_ydim();
	window_x=gatos_xdim();
	}else
#endif USE_DGA	
	{
	size=mwin->YSize();
	window_x=mwin->XSize();
	}
size=size/10;
if(	(channel==NULL)||
   	(lastchannel==NULL)|| 
	strcmp(lastchannel,string) || 
	(size!=lastchannelsize)){
	EraseChannel();
	if(transparent_letters)pal.bg_col=gatos_colorkey();
		else pal.bg_col=pal.black_col;
	channel=printString(string,"fixed",size,&pal);
	if(lastchannel!=NULL)free(lastchannel);
	lastchannel=strdup(string);
	lastchannelsize=size;
	lastchannel_x=channel_x;
	lastchannel_y=channel_y;
	}
channel_y=10;
channel_x=window_x-channel->width;
#ifdef USE_DGA
if(usedga && full){
	DGAPutImage((u8*)frame,mwin->XDeskSize(),channel_x,channel_y,channel);
	}else
#endif	
	{
	XPutImage(mwin->GetDisplay(),mwin->GetWindow(),mwin->GetGC(),
	 	channel,0,0,channel_x,channel_y,channel->width,channel->height);
	}

channelon=2*slider_timeout;
}



void ShowMessage(char *string)
{
int size;

// Don't want to hide old GUI. -ISG
//if(show){
//	toggleshow();
//	message_turn_gui_on=1;
//	}

#ifdef USE_DGA
if(usedga && full){
	size=gatos_ydim();
	}else
#endif USE_DGA	
	{
	size=mwin->YSize();
	}
size=size/10;
if(	(message==NULL)||
   	(lastmessage==NULL)|| 
	strcmp(lastmessage,string) || 
	(size!=lastmessagesize)){
	EraseMessage();
	if(transparent_letters)pal.bg_col=gatos_colorkey();
		else pal.bg_col=pal.black_col;
	message=printString(string,"fixed",size,&pal);
	if(lastmessage!=NULL)free(lastmessage);
	lastmessage=strdup(string);
	lastmessagesize=size;
	lastmessage_x=message_x;
	lastmessage_y=message_y;
	}
message_y=slider_y-message->height-5;
#ifdef USE_DGA
if(usedga && full){
	DGAPutImage((u8*)frame,mwin->XDeskSize(),message_x,message_y,message);
	}else
#endif	
	{
	XPutImage(mwin->GetDisplay(),mwin->GetWindow(),mwin->GetGC(),
	 	message,0,0,message_x,message_y,message->width,message->height);
	}

messageon=slider_timeout;
}

void EraseMessage(void)
{
if(message==NULL)return;
UniDrawRectangle(message_x,message_y,message->width,message->height,
				gatos_colorkey());
XFreeImage(message);
message=NULL;				
}

void ShowControl(void)
{
switch(message_mode){
	case MODE_VOLUME:
		DrawSlider(svol->Value(),100,2);
		ShowMessage("Volume");
		DrawSlider(svol->Value(),100,0);
		return;
        case MODE_BRIGHTNESS:
		DrawSlider(sbr->Value()-sbr->Min(),sbr->Max()-sbr->Min(),2);
	        ShowMessage("Brightness");
		DrawSlider(sbr->Value()-sbr->Min(),sbr->Max()-sbr->Min(),0);
		return;
        case MODE_CONTRAST:
		DrawSlider(scnt->Value()-scnt->Min(),scnt->Max()-scnt->Min(),2);
	        ShowMessage("Contrast");
		DrawSlider(scnt->Value()-scnt->Min(),scnt->Max()-scnt->Min(),0);
		return;
	case MODE_INPUT_SOURCE:
		DrawSlider(1,100,1);
		if(gatos_mux() == 3 || gatos_mux() == 0){
				 ShowMessage("Input:\\rS-Video");
				 }
			else if(gatos_mux() == 1){
				ShowMessage("Input:\\rComposite");
				 }
	      		else {
				 ShowMessage("Input:\\rTV signal");
				}
		return;
	case MODE_CC:
		DrawSlider(1,100,1);
		if(!useCC){
			ShowMessage("Caption:\\rNone");
			return;
			}
		switch(ccmode){
			case -1:
				ShowMessage("Caption:\\rNone");
				return;
			case CC_MODE_CC1: 
				ShowMessage("Caption:\\rCC1");
				return;
			case CC_MODE_CC2: 
				ShowMessage("Caption:\\rCC2");
				return;
			case CC_MODE_TEXT1:
				ShowMessage("Caption:\\rTEXT1");
				return;
			case CC_MODE_TEXT2:
				ShowMessage("Caption:\\rTEXT2");
				return;
			default:
				ShowMessage("Caption:\\rERROR");
				return;
			}
		return;
	case MODE_SAP:
		DrawSlider(1,100,1);
		if (gatos_sap())
		{
			if (gatos_stereo())
			{
				ShowMessage("Stereo/SAP:\\rST/SAP");
			} else
			{
				ShowMessage("Stereo/SAP:\\r  /SAP");
			}
		} else
		{
			if (gatos_stereo())
			{
				ShowMessage("Stereo/SAP:\\rST/");
			} else
			{
				ShowMessage("Stereo/SAP:\\r  /");
			}
		}
		
		return;
	default:
		return;
		}

}


int charNotValid(char c)
{
if(c==1)return 1;
if(c<10)return 1;
if((c>='a')&&(c<='z'))return 0;
if((c>='A')&&(c<='Z'))return 0;
if(c==' ')return 0;
if(c=='.')return 0;
if(c==':')return 0;
if(c==';')return 0;
if(c=='\'')return 0;
if(c=='?')return 0;
if(c=='-')return 0;
if(c=='\"')return 0;
return 2;
}

void cleanString(char *string)
{
int i,j;
for(i=0;string[i];i++)
	switch(charNotValid(string[i])){
		case 1:
			string[i]=' ';
			for(j=0;string[i+j];j++){
				string[i+j]=string[i+j+1];
				}
			i--;
			break;
		case 2: string[i]=' ';
			break;
		default: 
			break;
		}
}


void ShowCCText(void)
{
int size;
long window_x,window_y,slider_grid;
int i,j,k;
XImage *im;
GC gc;

if(!useCC)return;
if(ccmode<0)return;

gc=mwin->GetClipGC();

#ifdef USE_DGA
if(usedga && full){
	window_x=gatos_xdim();
	window_y=gatos_ydim();
	} else
#endif	 
	{
	window_x=mwin->XSize();
	window_y=mwin->YSize();
	}

/* slider grid is the minimum unit of graphic detail.
   It should be 10 at window_x=1024 and of course not less than 1 */
   
slider_grid=window_x/100;
if(slider_grid<1)slider_grid=1;

cctext_x=10;
size=window_x/24;
if(size>window_y/18)size=window_y/18;
if(size<1)size=1;
cctext_y=5;
if(transparent_letters)pal.bg_col=gatos_colorkey();
		else pal.bg_col=pal.black_col;


struct ccdata * ccdat=cc_get_data();
struct ccdata ccd=ccdat[ccmode];

if(*ccd.clrflag){
	EraseCCText();
	}
for(j=0;j<ccd.num_row;j++){
	k=ccd.row[j]-1;
	for(i=0;i<CC_COLUMNS;i++)
		{
		if(cctext_repaint || *ccd.clrflag || (ccd.attrib[j][i] & CC_ATTR_NEWCHAR)){
			ccd.attrib[j][i]&=~CC_ATTR_NEWCHAR;
			im=getCCChar(ccd.text[j][i],size,ccd.attrib[j][i],&pal);
			cctext_width=im->width;
			cctext_height=im->height;
			#ifdef USE_DGA
			if(usedga && full){
				DGAPutImage((u8*)frame,mwin->XDeskSize(),
					cctext_x+i*im->width,cctext_y+k*im->height,im);
				}else
			#endif	
				{
				XPutImage(mwin->GetDisplay(),mwin->GetWindow(),gc,
				 	im,0,0,cctext_x+i*im->width,cctext_y+k*im->height,im->width,im->height);
				}
			cctexton=slider_timeout;
			}
		}
	}
*ccd.clrflag=0;
cctext_repaint=0;
}

void EraseCCText(void)
{
long window_x,window_y;
long m;
#ifdef USE_DGA
if(usedga && full){
	window_x=gatos_xdim();
	window_y=gatos_ydim();
	} else
#endif	 
	{
	window_x=mwin->XSize();
	window_y=mwin->YSize();
	}
UniDrawRectangle(0,0,window_x,window_y,gatos_colorkey());
m=messageon;
if(m){
	ShowControl();
	messageon=m;
	}
}

void UniDrawRectangle(int x, int y,int width, int height, long color)
{
GC gc;
#ifdef USE_DGA
if(usedga && full){
	DGADrawRectangle((u8*)frame,depth,mwin->XDeskSize(),
			x,y,width,height,color);
	} else {
#endif	
	if(show)gc=mwin->GetClipGC();
		else gc=mwin->GetGC();
	XSetForeground(mwin->GetDisplay(),gc,color);
	XFillRectangle(mwin->GetDisplay(),mwin->GetWindow(),gc,x,y,width,height);
#ifdef USE_DGA
	}
#endif	
	
}

/* These are the constants that regulate green,yellow and red appearance
   the maximum is 100 */
long yellow_start=33;
long red_start=66;   

/* erase: 
    0 : do normal painting 
    1 : erase slider
    2 : only perform slider_x,slider_y calculation
    */
			
void DrawSlider(long value,long maxvalue,int erase)
{
long slider_width,slider_height,slider_grid,slider_height_small,slider_step;
long window_x,window_y;
long i;
long color;

#ifdef USE_DGA
if(usedga && full){
	window_x=gatos_xdim();
	window_y=gatos_ydim();
	} else
#endif	 
	{
	window_x=mwin->XSize();
	window_y=mwin->YSize();
	}

/* slider grid is the minimum unit of graphic detail.
   It should 10 at window_x=1024 and of course not less than 1 */
   
slider_grid=window_x/100;
if(slider_grid<1)slider_grid=1;

slider_y=window_y-6*slider_grid;
slider_width=window_x-4*slider_grid;
slider_height=4*slider_grid;
slider_height_small=slider_grid;
slider_step=slider_grid+slider_grid/2;
slider_x=2*slider_grid;
/* note that (slider_height-slider_height_small)/2==slider_step */
if(erase==2)return;
	
if(value<0)value=0;
if(maxvalue<0)maxvalue=1;
if(value>maxvalue)value=maxvalue;
if(erase==1){
	UniDrawRectangle(slider_x,slider_y,slider_width,slider_height,gatos_colorkey());
	slideron=0;
	slider_y=window_y;
	return;
	}
for(i=0;i<slider_width/(2*slider_step);i++){
	if(i*100*2*slider_step<yellow_start*slider_width)color=mwin->greencol;
		else
	if(i*100*2*slider_step<red_start*slider_width)color=mwin->yellowcol;
		else	color=mwin->redcol;
	if(i*maxvalue*2*slider_step<slider_width*value){
			/* draw big ones */
			UniDrawRectangle(slider_x+i*2*slider_step,slider_y,slider_step,slider_height,color);
			}else{
			/* draw dashes */
			UniDrawRectangle(slider_x+i*2*slider_step,slider_y,slider_step,slider_height,gatos_colorkey());
			UniDrawRectangle(slider_x+i*2*slider_step,slider_y+slider_step,slider_step,slider_height_small,color);
			}
	}
slideron=slider_timeout;
}

void EraseSlider(void)
{

}
	
void fullCB(IDoDad *p, IDoDad *d, int x)  {
  if(usedesk) { int tmpf=full; full=0; deskb->Press(0,0,0); full=tmpf; }
  if(x && full==0) {
#ifdef USE_DGA
    if(usedga) {
      depth = DefaultDepth(mwin->GetDisplay(), 0);
      XGrabKeyboard(mwin->GetDisplay(), DefaultRootWindow(mwin->GetDisplay()), True,
        GrabModeAsync, GrabModeAsync, CurrentTime);
      XGrabPointer(mwin->GetDisplay(), DefaultRootWindow(mwin->GetDisplay()), True,
        PointerMotionMask | ButtonPressMask | ButtonReleaseMask,
        GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
      XF86DGADirectVideo(mwin->GetDisplay(), 0, XF86DGADirectGraphics);
      {
        int ctr, n;
	double maxclock = gatos.aticard[gatos.cardidx].dotclock
		+ gatos_overclock();
	maxclock *= 1000.0;
        XF86VidModeModeInfo curv, **allv;
        XF86VidModeGetAllModeLines(mwin->GetDisplay(), 0, &n, &allv);
        oldv = *(allv[0]);
        curv = oldv;
         if(curv.dotclock >= maxclock) {
          for(ctr=0; ctr<n; ctr++)  {
            if(allv[ctr]->dotclock < maxclock
                && (allv[ctr]->hdisplay > curv.hdisplay
                || allv[ctr]->vdisplay > curv.vdisplay
                || curv.dotclock >= maxclock)) {
              curv = *(allv[ctr]);
	      }
            }
          }
        free(allv);
	XF86VidModeSwitchToMode(mwin->GetDisplay(), 0, &curv);
	}

     /* old code 
      if(depth<=8)
	memset((unsigned char *)frame, 0,
		mwin->YDeskSize( ) * mwin->XDeskSize());
      else if(depth<=16)
	memset((unsigned char *)frame, 0,
		mwin->YDeskSize( ) * mwin->XDeskSize() << 1);
      else if(depth<=32)
	memset((unsigned char *)frame, 0,
		mwin->YDeskSize( ) * mwin->XDeskSize() << 2);
      else { printf("AARRGGGHH!!\n"); exit(0); }

      gatos_setcolorkey(0); */
	
	
      XF86DGASetViewPort(mwin->GetDisplay(), 0, 0, 0);
      XF86DGAGetViewPortSize(mwin->GetDisplay(), 0, &ctrx, &ctry);
      gatos_setgeometry(ctrx,ctry,0,0);
      DGADrawRectangle((u8 *)frame,depth,mwin->XDeskSize(),
      	0,0,ctrx,ctry,gatos_colorkey());
      }
    else {
#endif
      tmpfar=far; far=0; oldx=mwin->XSize(); oldy=mwin->YSize();
      oldxp=mwin->XPos(); oldyp=mwin->YPos();
      XMoveResizeWindow(mwin->GetDisplay(),mwin->GetWindow(), 0, 0,
	mwin->XDeskSize(), mwin->YDeskSize());
#ifdef USE_DGA
      }
#endif
    full=1;
    }
  else if((!x) && full==1){
#ifdef USE_DGA
    if(usedga) {
//      XF86VidModeSwitchToMode(mwin->GetDisplay(), 0, &oldv);
      XUngrabPointer(mwin->GetDisplay(), CurrentTime);
      XUngrabKeyboard(mwin->GetDisplay(), CurrentTime);
      XF86VidModeSwitchToMode(mwin->GetDisplay(), 0, &oldv);
      XF86DGADirectVideo(mwin->GetDisplay(), 0, 0);
      gatos_setcolorkey(mwin->GetWinBGColor());
      gatos_setgeometry(mwin->XSize(), mwin->YSize(), mwin->XPos(), mwin->YPos());
      }
    else {
#endif
      XMoveResizeWindow(mwin->GetDisplay(),mwin->GetWindow(),
	oldxp, oldyp, oldx, oldy);
      far=tmpfar;
#ifdef USE_DGA
      }
#endif
    full=0;
    }

  }

//void iaCB(IDoDad *p, IDoDad *d, int x)  {
//  if((((ISButton *)d)->State()) && (!gatos_intaudio()))
//    gatos_setintaudio(1);
//  else if((((ISButton *)d)->State()==0) && (gatos_intaudio()))
//    gatos_setintaudio(0);
//  }

void svszCB(IDoDad *p, IDoDad *d, int x)  {
  svsz = ((ISButton *)d)->State();
  }

void farCB(IDoDad *p, IDoDad *d, int x)  {
  far = ((ISButton *)d)->State();
  }

void coldCB(IDoDad *p, IDoDad *d, int x)  {
  if((((ISButton *)d)->State()) && (!gatos_cold())) {
    gatos_setcold(1);
    }
  else if((((ISButton *)d)->State()==0) && (gatos_cold())) {
    gatos_setcold(0);
    }
  }

void muteCB(IDoDad *p, IDoDad *d, int x)  {
  if((((ISButton *)d)->State()) && (!gatos_mute())) {
    gatos_setmute(1);
    }
  else if((((ISButton *)d)->State()==0) && (gatos_mute())) {
    gatos_setmute(0);
    }
  }

void stereoCB(IDoDad *p, IDoDad *d, int x)  {
  if((((ISButton *)d)->State()==0) && gatos_stereo()) {
    gatos_setstereo(!gatos_stereo());
    }
  else if((((ISButton *)d)->State()) && (!gatos_stereo())) {
    gatos_setstereo(!gatos_stereo());
    }
  }

void sapCB(IDoDad *p, IDoDad *d, int x)  {
  if((((ISButton *)d)->State()==0) && gatos_sap()) {
    gatos_setsap(!gatos_sap());
    }
  else if((((ISButton *)d)->State()) && (!gatos_sap())) {
    gatos_setsap(!gatos_sap());
    }
  }

void guich(IDoDad *p, IDoDad *d, int x)  {
  if(d == aguib) advgui = ((ISButton*)d)->State();
  else if(d == chguib) changui = ((ISButton*)d)->State();
  else if(d == captguib) captgui = ((ISButton*)d)->State();
  else {
    fprintf(stderr, "Bad ButtonPress!\n");
    exit(1);
    }
  updategui();
  }

void snapcb(IDoDad *p, IDoDad *d, int n) {
  gatos_capture(captfl->GetText(), -1);
  }

void reccb(IDoDad *p, IDoDad *d, int n) {
  gatos_capture(captfl->GetText(), 0);
  stopb->Enable();
  }

void playcb(IDoDad *p, IDoDad *d, int n) {
  gatos_playback(captfl->GetText(), 0);
  stopb->Enable();
  }

void clearcb(IDoDad *p, IDoDad *d, int n) {
  unlink(captfl->GetText());
  }

void stopcb(IDoDad *p, IDoDad *d, int n) {
  gatos_stop();
  stopb->Disable();
  }

void cremcb(IDoDad *p, IDoDad *d, int) {
  gatos_delchan(gatos_channel());
  if(gatos_channel()>0) chnum->SetVal(gatos_channel());
  else chnum->SetVal(gatos_channel()+1);
  chnum->SetMax(gatos_numchans());
  chnum->SetMin(1);
  chchan(NULL, chnum);
  chnum->Redraw();
  }

void caddcb(IDoDad *p, IDoDad *d, int) {
  int ch = gatos_addchan(freq->GetVal(), "New Channel");
  chnum->Enable(); nameb->Enable();
  chnum->SetMax(gatos_numchans());
  chnum->SetVal(ch+1);
  updatechgui();
  chnum->Redraw();
  }

void cresetcb(IDoDad *p, IDoDad *d, int) {
  cvol->SetValue(0);
  cbr->SetValue(0);
  ccnt->SetValue(0);
  chue->SetValue(0);
  csat->SetValue(0);
  }

void chchan(IDoDad *p, IDoDad *d)  {
  timeval tv;
  gettimeofday(&tv, NULL);
  time_t tmpt = tv.tv_sec;
  if(prevch != gatos_channel() && lasttime < (tmpt-5)) {
    prevch = gatos_channel();
    }
  lasttime = tmpt;

  if(gatos_mux()==2) {
  	 gatos_setchan(((IIntBox *)d)->GetVal()-1);
	 }
  cc_reset(); 
#ifdef CC_CURSES
  if(useCC) cc_show();
#else
  EraseCCText();	
  if(useCC) ShowCCText();
#endif
  updatetextbox();
  updatechgui();
  /* Display message about a new channel */
  if(!show)
	ShowChannel(chnb->GetText());
  }

void mixerCB(IDoDad *p, IDoDad *d, int n)  {
  gatos_setmixer(n);
  }

void formatCB(IDoDad *p, IDoDad *d, int n)  {
  gatos_setformat(format_nums[n]);
  }

void setupCB(IDoDad *p, IDoDad *d, int n)  {
  if(((IButton *)d) == setupb) setupgui=1;
  else if(((IButton *)d) == doneb) setupgui=0;
  else {
    fprintf(stderr, "Bad ButtonPress!\n");
    exit(1);
    }
  updategui();
  }

static int scan_cancel = 0;

void canCB(IDoDad *p, IDoDad *d, int n)  {
  scan_cancel = 1;
  }

int scannerCB(double p) {
  mwin->DispatchCurrentEvents();
  csisb->SetProgress(p-gatos_minfreq());
  csisb->Redraw();
  return (scan_cancel || mwin->HasQuit());
  }

void scanchan(IDoDad *p, IDoDad *d, int n)  {
  int sh=show; show=0; updategui();
  scan_cancel = 0;
  csitb1->Show();
  csitb2->Show();
  csitp1->Show();
  csitp2->Show();
  csisb->SetTotalWork(gatos_maxfreq()-gatos_minfreq());
  csisb->SetProgress(0.0);
  csisb->Show();
  cscan->Show();
  if(d==rescanb) chan_clearchans();
  gatos_chanscan(scannerCB);
  csitb1->Hide();
  csitb2->Hide();
  csitp1->Hide();
  csitp2->Hide();
  csisb->Hide();
  cscan->Hide();
  chnum->SetMax(gatos_numchans());
  chnum->SetMin(1);
  chchan(NULL, chnum);
  show=sh; updategui();
  }

void toggleshow() {
  show = !show;
  updategui();
  }

void updatechgui() {
  cfreq->SetChangeCallback(NULL);
  cvol->SetChangeCallback(NULL);
  cbr->SetChangeCallback(NULL);
  ccnt->SetChangeCallback(NULL);
  chue->SetChangeCallback(NULL);
  csat->SetChangeCallback(NULL);
  freq->SetChangeCallback(NULL);

  cfreq->SetVal(gatos_chanfreq(gatos_channel())); cfreq->Redraw();
  cvol->SetValue(gatos_chanvolume(gatos_channel()));
  cbr->SetValue(gatos_chanbrightness(gatos_channel()));
  ccnt->SetValue(gatos_chancontrast(gatos_channel()));
  chue->SetValue(gatos_chanhue(gatos_channel()));
  csat->SetValue(gatos_chansaturation(gatos_channel()));

  freq->SetVal(gatos_chanfreq(gatos_channel()));
  freq->Redraw();
  cfreq->SetChangeCallback(&chcfreq);
  cvol->SetChangeCallback(csld);
  cbr->SetChangeCallback(csld);
  ccnt->SetChangeCallback(csld);
  chue->SetChangeCallback(csld);
  csat->SetChangeCallback(csld);
  freq->SetChangeCallback(&chfreq);
  }

void updategui() {
  csitb1->Hide();
  csitb2->Hide();
  csitp1->Hide();
  csitp2->Hide();
  csisb->Hide();
  cscan->Hide();
  if(show && (!setupgui)) {
    setupb->Show();
    aguib->Show();
    chguib->Show();
    captguib->Show();
    inp1->Show();
    inp2->Show();
    inp3->Show();
    svol->Show();
    chnum->Show();
    nameb->Show();
    muteb->Show();
    CCt->Show();
    }
  else {
    setupb->Hide();
    aguib->Hide();
    chguib->Hide();
    captguib->Hide();
    inp1->Hide();
    inp2->Hide();
    inp3->Hide();
    svol->Hide();
    chnum->Hide();
    nameb->Hide();
    muteb->Hide();
    CCt->Hide();
    }
  if(show && (!setupgui) && advgui) {
    sbr->Show();
    scnt->Show();
    shue->Show();
    ssat->Show();
    stereob->Show();
    fullb->Show();
    sapb->Show();
    coldb->Show();
    gammas->Show();
    freq->Show();
    cadd->Show();
    }
  else {
    sbr->Hide();
    scnt->Hide();
    shue->Hide();
    ssat->Hide();
    stereob->Hide();
    fullb->Hide();
    sapb->Hide();
    coldb->Hide();
    gammas->Hide();
    freq->Hide();
    cadd->Hide();
    }
  if(show && (!setupgui) && captgui) {
    snapb->Show();
    playb->Show();
    recb->Show();
    stopb->Show();
    clearb->Show();
    captfl->Show();
    xcaptb->Show();
    ycaptb->Show();
    }
  else {
    snapb->Hide();
    playb->Hide();
    recb->Hide();
    stopb->Hide();
    clearb->Hide();
    captfl->Hide();
    xcaptb->Hide();
    ycaptb->Hide();
    }
  if(show && (!setupgui) && changui) {
    cvol->Show();
    cbr->Show();
    ccnt->Show();
    chue->Show();
    csat->Show();
    crem->Show();
    creset->Show();
    cfreq->Show();
    scanb->Show();
    chnb->Show();
    }
  else {
    cvol->Hide();
    cbr->Hide();
    ccnt->Hide();
    chue->Hide();
    csat->Hide();
    crem->Hide();
    creset->Hide();
    cfreq->Hide();
    scanb->Hide();
    chnb->Hide();
    }
  if(show && setupgui) {
    formb->Show();
    forml->Show();
    optl->Show();
    if((gatos_audiotype() & 1) && (mixl)) { mixl->Show(); mixerb->Show(); }
    svszb->Show();
    farb->Show();
    doneb->Show();
    rescanb->Show();
    deskb->Show();
    CCb->Show();
    CCl->Show();
    topb->Show();
    dotb->Show();
    dotl->Show();
    ahb->Show();
    ahl->Show();
    senscb->Show();
#ifdef USE_DGA
    dgab->Show();
#endif
#ifdef GATOSBUTTONS
    int ctr;
    for(ctr=0; ctr<GATOSBUTTONS; ++ctr) {
      testb[ctr]->Show();
      testl[ctr]->Show();
      }
#endif
    }
  else {
    formb->Hide();
    if(mixl) {
      mixerb->Hide();
      mixl->Hide();
      }
    forml->Hide();
    optl->Hide();
    svszb->Hide();
    farb->Hide();
    doneb->Hide();
    rescanb->Hide();
    deskb->Hide();
    CCb->Hide();
    CCl->Hide();
    topb->Hide();
    dotb->Hide();
    dotl->Hide();
    ahb->Hide();
    ahl->Hide();
    senscb->Hide();
#ifdef USE_DGA
    dgab->Hide();
#endif
#ifdef GATOSBUTTONS
    int ctr;
    for(ctr=0; ctr<GATOSBUTTONS; ++ctr) {
      testb[ctr]->Hide();
      testl[ctr]->Hide();
      }
#endif
    }
  mwin->RebuildClip();
  mwin->Redraw();
  cctext_repaint=1;
  ShowCCText();
  }

void initgui() {
  setupb = new IButton("Setup", mwin, 80, 10, 40, 20);
  setupb->SetClickCallback(&setupCB); 
  aguib = new ISButton("Adv.", mwin, 120, 10, 40, 20);
  if(advgui) aguib->Press(0, 0, 0);
  aguib->SetDownCallback(&guich); aguib->SetUpCallback(&guich);
  captguib = new ISButton("Capture", mwin, 160, 10, 50, 20);
  if(captgui) captguib->Press(0, 0, 0);
  captguib->SetDownCallback(&guich); captguib->SetUpCallback(&guich);
  chguib = new ISButton("Edit Channel", mwin, 130, 70, 80, 20);
  if(changui) chguib->Press(0, 0, 0);
  chguib->SetDownCallback(&guich); chguib->SetUpCallback(&guich);
  inp3 = new ISButton("TV", mwin, 10, 10, 20, 20);
  inp2 = new ISButton("CV", mwin, 30, 10, 20, 20);
  inp1 = new ISButton("SV", mwin, 50, 10, 20, 20);
  inp1->SetDownCallback(inp); if(gatos_mux()==3 || gatos_mux()==0) inp1->Press(0,0,0);
  inp2->SetDownCallback(inp); if(gatos_mux()==1) inp2->Press(0,0,0);
  inp3->SetDownCallback(inp); if(gatos_mux()==2) inp3->Press(0,0,0);
  svol = new ISlider("Volume: ", mwin, 10, 30, 150, 20);
  svol->SetMin(0); svol->SetMax(100); svol->SetValue(gatos_volume());
  svol->SetChangeCallback(sld);
//  if(!gatos_audiotype()) svol->Disable();
  muteb = new ISButton("Mute", mwin, 160, 30, 30, 20);
  muteb->SetDownCallback(muteCB); muteb->SetUpCallback(muteCB);
  if(gatos_mute()) muteb->Press(0, 0, 0);
  if(!gatos_audiotype()) muteb->Disable();
  CCt = new ISButton("CC", mwin, 190, 30, 20, 20);
  CCt->SetDownCallback(CCtCB); CCt->SetUpCallback(CCtCB);
  chnum = new IIntBox(1, mwin, 10, 50, 50, 20);
  chnum->SetMin(1);
  chnum->SetMax(gatos_numchans()); chnum->SetVal(gatos_channel()+1);
  chnum->SetFlags(IBTK_WRAP|IBTK_SUPPLEMENTARY);
  chnum->SetChangeCallback(chchan);
  if(gatos_mux() != 2) chnum->Disable();
  nameb = new IBox("", mwin, 60, 50, 150, 20);
  nameb->SetChangeCallback(chname);
  freq = new IRealBox(gatos_chanfreq(gatos_channel()),
	mwin, 10, 70, 80, 20);
  freq->SetMin(gatos_minfreq()); freq->SetMax(gatos_maxfreq());
  freq->SetIncVal(0.0625); freq->SetChangeCallback(&chfreq);
  cadd = new IButton("Add", mwin, 90, 70, 40, 20);
  cadd->SetClickCallback(&caddcb);

  sbr = new ISlider("Brightness: ", mwin, 10, 90, 200, 20);
  sbr->SetMin(0); sbr->SetMax(200); sbr->SetValue(gatos_brightness());
  sbr->SetChangeCallback(sld);
  scnt = new ISlider("Contrast: ", mwin, 10, 110, 200, 20);
  scnt->SetMin(0); scnt->SetMax(200); scnt->SetValue(gatos_contrast());
  scnt->SetChangeCallback(sld);
  shue = new ISlider("Hue: ", mwin, 10, 130, 200, 20);
  shue->SetMin(-90); shue->SetMax(90); shue->SetValue(gatos_hue());
  shue->SetChangeCallback(sld);
  ssat = new ISlider("Saturation: ", mwin, 10, 150, 200, 20);
  ssat->SetMin(0); ssat->SetMax(200); ssat->SetValue(gatos_saturation());
  ssat->SetChangeCallback(sld);
  stereob = new ISButton("Stereo", mwin, 100, 170, 50, 20);
  stereob->SetDownCallback(stereoCB); stereob->SetUpCallback(stereoCB);
  if(gatos_stereo()) stereob->Press(0, 0, 0);
  sapb = new ISButton("SAP", mwin, 150, 170, 30, 20);
  sapb->SetDownCallback(sapCB); sapb->SetUpCallback(sapCB);
  if(gatos_sap()) sapb->Press(0, 0, 0);
  fullb = new ISButton("Full", mwin, 180, 170, 30, 20);
  fullb->SetDownCallback(fullCB); fullb->SetUpCallback(fullCB);
  coldb = new ISButton("Cold", mwin, 10, 170, 30, 20);
  coldb->SetDownCallback(coldCB); coldb->SetUpCallback(coldCB);
  if(gatos_cold()) coldb->Press(0, 0, 0);
  gammas = new ISlider("Gamma: ", mwin, 40, 170, 60, 20);
  gammas->SetMin(0); gammas->SetMax(3); gammas->SetValue(gatos_gamma());
  gammas->SetChangeCallback(sld);

  clearb = new IButton("Delete", mwin, 30, 200, 40, 20);
  clearb->SetClickCallback(&clearcb);
  captfl = new IBox("gatos.yuv", mwin, 70, 200, 120, 20);
  snapb = new IButton("Snap", mwin, 30, 220, 40, 20);
  snapb->SetClickCallback(&snapcb);
  recb = new IButton("Rec", mwin, 70, 220, 40, 20);
  recb->SetClickCallback(&reccb);
  playb = new IButton("Play", mwin, 110, 220, 40, 20);
  playb->SetClickCallback(&playcb);
  stopb = new IButton("Stop", mwin, 150, 220, 40, 20);
  stopb->Disable(); stopb->SetClickCallback(&stopcb);
  xcaptb = new IIntBox(gatos_xcapt(), mwin, 30, 240, 80, 20);
  xcaptb->SetMin(gatos_xcaptmin()); xcaptb->SetMax(gatos_xcaptmax());
  xcaptb->SetChangeCallback(&chcapt);
  ycaptb = new IIntBox(gatos_ycapt(), mwin, 110, 240, 80, 20);
  ycaptb->SetMin(gatos_ycaptmin()); ycaptb->SetMax(gatos_ycaptmax());
  ycaptb->SetChangeCallback(&chcapt);

  scanb = new IButton("Scan", mwin, 220, 10, 50, 20);
  scanb->SetDownCallback(scanchan);
  crem = new IButton("Remove", mwin, 270, 10, 50, 20);
  crem->SetClickCallback(&cremcb);
  cfreq = new IRealBox(gatos_chanfreq(gatos_channel()),
	mwin, 220, 30, 100, 20);
  cfreq->SetMin(gatos_minfreq()); cfreq->SetMax(gatos_maxfreq());
  cfreq->SetIncVal(0.0625); cfreq->SetChangeCallback(&chcfreq);
  chnb = new IBox("", mwin, 220, 50, 100, 20);
  chnb->SetChangeCallback(chdesc);
  updatetextbox();
  cvol = new ISlider("Vol: ", mwin, 220, 70, 100, 20);
  cvol->SetMin(-30); cvol->SetMax(30);
  cvol->SetValue(gatos_chanvolume(gatos_channel()));
  cvol->SetChangeCallback(csld);
//  if(!gatos_audiotype()) cvol->Disable();
  cbr = new ISlider("Bright: ", mwin, 220, 90, 100, 20);
  cbr->SetMin(-30); cbr->SetMax(30);
  cbr->SetValue(gatos_chanbrightness(gatos_channel()));
  cbr->SetChangeCallback(csld);
  ccnt = new ISlider("Contr: ", mwin, 220, 110, 100, 20);
  ccnt->SetMin(-30); ccnt->SetMax(30);
  ccnt->SetValue(gatos_chancontrast(gatos_channel()));
  ccnt->SetChangeCallback(csld);
  chue = new ISlider("Hue: ", mwin, 220, 130, 100, 20);
  chue->SetMin(-30); chue->SetMax(30);
  chue->SetValue(gatos_chanhue(gatos_channel()));
  chue->SetChangeCallback(csld);
  csat = new ISlider("Sat: ", mwin, 220, 150, 100, 20);
  csat->SetMin(-30); csat->SetMax(30);
  csat->SetValue(gatos_chansaturation(gatos_channel()));
  csat->SetChangeCallback(csld);
  creset = new IButton("Set to Default", mwin, 220, 170, 100, 20);
  creset->SetClickCallback(&cresetcb);

  forml = new ITextBox("Select Video Format", mwin, 10, 10, 300, 20);
  formb = new IListBox(format_names, NUM_FORMATS, mwin, 10, 30, 300,
	NUM_FORMATS*13+6);
  formb->SetSelCallback(formatCB); formb->SetDCCallback(formatCB);
  if(gatos_nummixers() > 0) {
    mixl = new ITextBox("Mixer", mwin, 450, 10, 100, 20);
    mixerb = new IListBox(gatos_mixernames(), gatos_nummixers(),
	mwin, 450, 30, 100, gatos_nummixers()*13+6);
    mixerb->Select(gatos_mixer());
    mixerb->SetSelCallback(mixerCB); mixerb->SetDCCallback(mixerCB);
    }
  optl = new ITextBox("Options", mwin, 320, 10, 120, 20);
  svszb = new ISButton("Save Window Size", mwin, 320, 30, 120, 20);
  if(svsz) svszb->Press(0, 0, 0);
  svszb->SetDownCallback(svszCB); svszb->SetUpCallback(svszCB);
  farb = new ISButton("Fixed Aspect Ratio", mwin, 320, 50, 120, 20);
  if(far) farb->Press(0, 0, 0);
  farb->SetDownCallback(farCB); farb->SetUpCallback(farCB);
  topb = new ISButton("Always On Top", mwin, 320, 70, 120, 20);
  if(ontop) topb->Press(0,0,0);
  topb->SetDownCallback(topCB); topb->SetUpCallback(topCB);
  deskb = new ISButton("Use Desktop Mode", mwin, 320, 90, 120, 20);
  deskb->SetDownCallback(deskCB); deskb->SetUpCallback(deskCB);
  if(usedesk) deskb->Press(0,0,0);
  ahb = new IIntBox((useautohide+99)/100, mwin, 400, 110, 40, 20);
  ahb->SetMin(0); ahb->SetMax(10); ahb->SetChangeCallback(ahCB);
  ahl = new ISButton("Autohide", mwin, 320, 110, 80, 20);
  ahl->SetDownCallback(ahlCB); ahl->SetUpCallback(ahlCB);
  if(useautohide) ahl->Press(0,0,0);
  else ahb->Disable();
  senscb = new ISButton("Use Sensitive SCAN", mwin, 320, 130, 120, 20);
  if(gatos_senscan()) senscb->Press(0,0,0);
  senscb->SetDownCallback(senscCB); senscb->SetUpCallback(senscCB);
  dotl = new ITextBox("Overclock", mwin, 320, 150, 80, 20);
  dotb = new IIntBox(gatos_overclock(), mwin, 400, 150, 40, 20);
  dotb->SetMin(-20); dotb->SetMax(20); dotb->SetChangeCallback(dotCB);
#ifdef USE_DGA
  dgab = new ISButton("Use DGA/VM", mwin, 320, 170, 120, 20);
  if(usedga) dgab->Press(0,0,0);
  dgab->SetDownCallback(dgaCB); dgab->SetUpCallback(dgaCB);
#endif

#ifdef GATOSBUTTONS
  int ctr; char buf[16];
  for(ctr=0; ctr<GATOSBUTTONS; ++ctr) {
    sprintf(buf, "Test Var #%d%c", ctr+1, 0);
    testl[ctr] = new ITextBox(buf, mwin, 320, 200+(20*ctr), 80, 20);
    testb[ctr] = new IIntBox(gatos_testbutton(ctr), mwin,
	400, 200+(20*ctr), 40, 20);
    testb[ctr]->SetMin(-1000000); testb[ctr]->SetMax(1000000);
    testb[ctr]->SetChangeCallback(testCB);
    }
#endif

  CCb = new ITextBox("CC Mode", mwin, 10, NUM_FORMATS*13+46, 120, 20);
  char *ccms[4] = { "CC1", "CC2", "Text1", "Text2" };
  CCl = new IListBox(ccms, 4, mwin, 10, NUM_FORMATS*13+66, 120, 4*13+6);
  CCl->Select(ccmode); CCl->SetSelCallback(CCCB);

  rescanb = new IButton("Rescan Channels", mwin, 150, NUM_FORMATS*13+46, 100, 20);
  rescanb->SetClickCallback(&scanchan); 

  doneb = new IButton("Done", mwin, 270, NUM_FORMATS*13+46, 40, 20);
  doneb->SetClickCallback(&setupCB); 

  csitb1 = new ITextBox("Scanning For Channels", mwin, 10, 10, 200, 20);
  csitp1 = new ITextBox("", mwin, 10, 30, 20, 20);
  csisb = new IStatBar(mwin, 30, 30, 160, 20);
  csitp2 = new ITextBox("", mwin, 190, 30, 20, 20);
  csitb2 = new ITextBox("Please Be Patient", mwin, 10, 50, 200, 20);
  cscan = new IButton("Done", mwin, 170, 70, 40, 20);
  cscan->SetClickCallback(&canCB);

  updategui();
  updatetextbox();
  mwin->Redraw();
  }

void loadstate() {
  gatos_getintvalue("Autohide=", &useautohide);
  gatos_getintvalue("ShowGUI=", &show);
  gatos_getintvalue("ChanGUI=", &changui);
  gatos_getintvalue("CaptGUI=", &captgui);
  gatos_getintvalue("AdvGUI=", &advgui);

  gatos_getintvalue("SaveSize=", &svsz);
  gatos_getintvalue("FixedAspectRatio=", &far);
#ifdef USE_DGA
  gatos_getintvalue("UseDGA=", &usedga);
#endif
  gatos_getintvalue("UseDesktopMode=", &usedesk);
  gatos_getintvalue("AlwaysOnTop=", &ontop);
  gatos_getintvalue("CC_Mode=", &ccmode);
  gatos_getintvalue("FavChannel1=", &favch[0]);
  gatos_getintvalue("FavChannel2=", &favch[1]);
  gatos_getintvalue("FavChannel3=", &favch[2]);
  gatos_getintvalue("FavChannel4=", &favch[3]);
  gatos_getintvalue("FavChannel5=", &favch[4]);
  gatos_getintvalue("FavChannel6=", &favch[5]);
  gatos_getintvalue("FavChannel7=", &favch[6]);
  gatos_getintvalue("FavChannel8=", &favch[7]);
  gatos_getintvalue("SaveSize=", &svsz);
  if(svsz) {
    gatos_getintvalue("XSize=", &ixs);
    gatos_getintvalue("YSize=", &iys);
    }
  }

void savestate() {
  gatos_setintvalue("Autohide=", useautohide);
  gatos_setintvalue("ShowGUI=", show);
  gatos_setintvalue("ChanGUI=", changui);
  gatos_setintvalue("CaptGUI=", captgui);
  gatos_setintvalue("AdvGUI=", advgui);
  gatos_setintvalue("SaveSize=", svsz);
  gatos_setintvalue("FixedAspectRatio=", far);
#ifdef USE_DGA
  gatos_setintvalue("UseDGA=", usedga);
#endif
  gatos_setintvalue("UseDesktopMode=", usedesk);
  gatos_setintvalue("AlwaysOnTop=", ontop);
  gatos_setintvalue("CC_Mode=", ccmode);
  gatos_setintvalue("FavChannel1=", favch[0]);
  gatos_setintvalue("FavChannel2=", favch[1]);
  gatos_setintvalue("FavChannel3=", favch[2]);
  gatos_setintvalue("FavChannel4=", favch[3]);
  gatos_setintvalue("FavChannel5=", favch[4]);
  gatos_setintvalue("FavChannel6=", favch[5]);
  gatos_setintvalue("FavChannel7=", favch[6]);
  gatos_setintvalue("FavChannel8=", favch[7]);
  gatos_setintvalue("SaveSize=", svsz);
  gatos_setintvalue("XSize=", mwin->XSize());
  gatos_setintvalue("YSize=", mwin->YSize());
  }
