# Copyright (C) 2004,2005 by SICEm S.L.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import gtk

from gazpacho.widget import get_widget_from_gtk_widget

class CustomPropertyEditor(gtk.Dialog):
    """This is a base abstract class for those editors that need to be
    opened in a dialog.
    """

    def __init__(self):
        """The widgets of the dialog are created in the virtual method
        _create_widgets.
        """
        gtk.Dialog.__init__(self,
                            title='',
                            parent=None,
                            flags=gtk.DIALOG_DESTROY_WITH_PARENT,
                            buttons=(gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE))
        self.widget = None
        self.gwidget = None
        self.proxy = None
        
        # avoid destrcution when clicking the x button
        self.connect('delete-event', self._on_delete_event)
        self.connect('response', self._on_response)

        self.set_border_width(6)
        self.set_resizable(False)
        self.set_has_separator(False)
        self.vbox.set_spacing(6)
        
        self._create_widgets()

        self.vbox.show_all()

    def _create_widgets(self):
        """Subclasses should override this."""

    def set_widget(self, widget, proxy):
        """Every time the user clicks on a custom property editor button
        we are called with a different widget and proxy.
        """
        self.widget = widget
        self.proxy = proxy
        self.gwidget = get_widget_from_gtk_widget(widget)

    def _on_delete_event(self, dialog, event):
        self.hide()
        return True
    
    def _on_response(self, dialog, response_id):
        self.hide()

