/* Gnome BibTeX lyxsup.C
 *    Copyright 1998 Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 * 
 *    This program is free software; you can redistribute it and'or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2, or (at your option)
 *    any later version.
 */

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h> 
#include <gnome.h> 
#include "gbib.h"  
#include "lyxconnect.h"  


extern int bib_style;

LyXConnect lyxconnect;

bool lyxdialog_open = false;

extern BibentryTable etable;

void lyx_dialog();

void lyx_cp(GtkWidget *w, gpointer data)
{
    if (!lyxdialog_open) {
	lyx_dialog();
    }
}

void dialog_quit_cb(GtkWidget *widget, void *data)
{
    lyxdialog_open = false;
    gnome_dialog_close(GNOME_DIALOG(widget));
    lyxconnect.closepipe();
    return;
}

void lyxdialog_clicked_cb(GnomeDialog * dialog, gint button_number, 
			  gpointer data)
{
    switch (button_number) {
     case 0: 
	lyxdialog_open = false;
	gnome_dialog_close(dialog);
	lyxconnect.closepipe();
	break;
    };
}


void lyxbib_clicked_cb(GnomeDialog * dialog, gint button_number, 
			  gpointer data)
{
    BibEntry *bib = etable.get_entry(etable.selected_entry);

    if (!bib)
      return;
     
    switch (button_number) {
     case 0: 
	// Insert a citation reference to the selected entry
	lyxconnect.submit("citation-insert", bib->getKey());
	break;
     case 1:
        {
	    // Insert a bibtex inset with the current database
	    string arg = etable.dbname;
	    
	   // Not use the default style
	    if (bib_style) {
		arg += " ";
		arg += get_bibtex_style(bib_style);
	    }
	    lyxconnect.submit("bibtex-insert", arg.c_str());
	    break;
	}
     case 2:
	// Insert additional databases to an existing bibtex inset
	lyxconnect.submit("bibtex-database-add", etable.dbname.c_str());
	break;
    };
}



void lyx_dialog()
{
    GtkWidget* dialog;
    GtkWidget* button;
    GtkWidget * pixmap;
    
//    dialog = gtk_vbox_new(FALSE, 0);
  
    
    dialog = gnome_dialog_new("LyX BibTeX support", 
			      GNOME_STOCK_BUTTON_CLOSE, 
			      NULL); 

    gtk_signal_connect(GTK_OBJECT (dialog),
		       "clicked", GTK_SIGNAL_FUNC(lyxdialog_clicked_cb), 
		       NULL);

    string libdir = LIBDIR;
    libdir += "/lyx.xpm";
    
    pixmap = gnome_pixmap_new_from_file(libdir.c_str());
//      gnome_pixmap_new_from_file("lyx.xpm");
    
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), 
			pixmap, TRUE, TRUE, 0);
    gtk_widget_show(pixmap);
    
    button = gtk_button_new_with_label("Insert cite");
    gtk_box_pack_start (GTK_BOX(GNOME_DIALOG(dialog)->vbox),
			button, TRUE, TRUE, 0);
    gtk_widget_show(button);
    gtk_signal_connect(GTK_OBJECT (button),
		       "clicked", GTK_SIGNAL_FUNC(lyxbib_clicked_cb), 
		       (void*)0);
    
    button = gtk_button_new_with_label("Insert bibtex");
    gtk_box_pack_start (GTK_BOX(GNOME_DIALOG(dialog)->vbox),
			button, TRUE, TRUE, 0);
    gtk_widget_show(button);    
    gtk_signal_connect(GTK_OBJECT (button),
		       "clicked", GTK_SIGNAL_FUNC(lyxbib_clicked_cb), 
		       (void*)1);
  
    button = gtk_button_new_with_label("Insert database");
    gtk_box_pack_start (GTK_BOX(GNOME_DIALOG(dialog)->vbox),
			button, TRUE, TRUE, 0);
    gtk_widget_show(button);  
    gtk_signal_connect(GTK_OBJECT (button),
		       "clicked", GTK_SIGNAL_FUNC(lyxbib_clicked_cb), 
		       (void*)2);
  
    lyxdialog_open = true;
    lyxconnect.connect(); 
    GTK_WINDOW (dialog)->type = GTK_WINDOW_TOPLEVEL;
    
    gtk_signal_connect (GTK_OBJECT (dialog), "destroy",
                        GTK_SIGNAL_FUNC (dialog_quit_cb), NULL);
    
    gtk_widget_show(dialog);
}

