/*
 * Gnome-biff program
 * Version:  2.6
 * Copyright (C) 2000-2001  Nicolas Rougier
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __PROTOCOL_HH
#define __PROTOCOL_HH

#include "gbiff.h"

#define STATUS_NEW_MAIL		0
#define STATUS_OLD_MAIL		1
#define STATUS_NO_MAIL		2

int FILE_checkmail (Biff *biff);
int FILE_getheaders (Biff *biff);

int MAILDIR_checkmail (Biff *biff);
int MAILDIR_getheaders (Biff *biff);

int MH_checkmail (Biff *biff);
int MH_getheaders (Biff *biff);

int POP3_checkmail (Biff *biff);
int POP3_getheaders (Biff *biff);

int IMAP4_checkmail (Biff *biff);
int IMAP4_getheaders (Biff *biff);

int socket_open (char *hostname, unsigned short int port);
int socket_write (int socketFD, char *line);
char *socket_read (int socketFD);
void socket_close (int socketFD);

char *parse_ISO_8859 (char *text);
int parse_base64 (const char *buftodec, int bufsize, char *decbuf);

#endif /* __PROTOCOL_HH */
