/*
 * Gnome-biff program
 * Version:  2.6
 * Copyright (C) 2000-2001  Nicolas Rougier
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "gbiff.h"
#include "window.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"

/********************************************************************************
 * Function: Create a window onto screen
 * Input   : A biff structure
 * Output  : /
 * Return  : A toplevel window
 ********************************************************************************/
GtkWidget *create_Window (Biff *biff) {
  GtkWidget *Window = 0;
  GtkWidget *DrawingArea;

  Window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (Window), "Window", Window);
  if (!Window)
    g_error(_("Can't create window\n"));
  gtk_window_set_policy (GTK_WINDOW (Window), FALSE, FALSE, FALSE);
  gtk_widget_realize (Window);

  DrawingArea = gtk_drawing_area_new ();
  gtk_widget_set_name (DrawingArea, "DrawingArea");
  gtk_widget_ref (DrawingArea);
  gtk_object_set_data_full (GTK_OBJECT (Window), "DrawingArea", DrawingArea,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_set_events (DrawingArea, GDK_ALL_EVENTS_MASK);
  gtk_container_add (GTK_CONTAINER (Window), DrawingArea);
  gtk_widget_set_usize (DrawingArea, 48, 48); 
  gtk_widget_show (DrawingArea);
  gtk_widget_realize (Window);

  gtk_signal_connect (GTK_OBJECT (Window), "leave_notify_event",
                      GTK_SIGNAL_FUNC (on_Window_leave_notify_event),
                      biff);
  gtk_signal_connect (GTK_OBJECT (Window), "destroy_event",
		      GTK_SIGNAL_FUNC (gtk_exit),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (Window), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_exit),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (DrawingArea), "expose_event",
		      GTK_SIGNAL_FUNC (on_WindowDrawingArea_expose),
		      biff);
  gtk_signal_connect (GTK_OBJECT (DrawingArea), "configure_event",
		      GTK_SIGNAL_FUNC (on_WindowDrawingArea_configure),
		      biff);
  gtk_signal_connect (GTK_OBJECT (DrawingArea), "button_press_event",
		      GTK_SIGNAL_FUNC (on_WindowDrawingArea_button_press),
		      biff);
  gtk_signal_connect (GTK_OBJECT (DrawingArea), "button_release_event",
		      GTK_SIGNAL_FUNC (on_WindowDrawingArea_button_release),
		      biff);

  biff->mailGdkPixmap = gdk_pixmap_create_from_xpm (DrawingArea->window, NULL, NULL, biff->mailPixmapFilename);
  biff->nomailGdkPixmap = gdk_pixmap_create_from_xpm (DrawingArea->window, NULL, NULL, biff->nomailPixmapFilename);

  gtk_widget_realize (Window);

  return (Window);
}

/********************************************************************************
 * Function: Update the window according to mail status
 * Input   : A biff structure and a status:  0 if no error
 *                                          -1 if error
 *                                          -2 to leave current message unchanged
 * Output  : Onto window
 * Return  : /
 ********************************************************************************/
void updateWindow (Biff *biff, int status) {
  static char unread[16];
  static GdkFont *font;
  static GdkColor forecolor;
  static GdkGC *myGC = 0;
  static GdkPixmap *pixmap = 0;
  int width, height, x, y;
  GtkWidget *DA = lookup_widget (biff->window, "DrawingArea");

  /* Get the size of the window */
  gdk_window_get_size (biff->window->window, &width, &height);

  /* Create a gc if none available */
  if (myGC == 0) {
    pixmap = biff->nomailGdkPixmap;
    myGC = gdk_gc_new (DA->window);
    gdk_color_parse ("black", &forecolor);
    gdk_color_alloc (gtk_widget_get_colormap (DA), &forecolor);
    gdk_gc_set_foreground (myGC, &forecolor);
    sprintf (unread, _("Unread:00"));
  };
  
  /* Set text to be displayed and the right pixmap */
  if (status > -1) {
    if (biff->unread < MAX_HEADER_IN_POPUP) {
      sprintf (unread, "Unread:%.2d", biff->unread);
      pixmap = biff->mailGdkPixmap;
      if (biff->unread == 0)
	pixmap = biff->nomailGdkPixmap;
    }
    else {
      pixmap = biff->mailGdkPixmap;
      sprintf  (unread, _("Unread:++"));
    }
  }
  else if (status == -1) {
    pixmap = biff->nomailGdkPixmap;
    sprintf  (unread, _("Unread:--"));
  };

  /* Display pixmap */
  gdk_draw_pixmap (DA->window, myGC, pixmap, 0,0, 0,0, width, height);

  /* Load a font if needed */
  if (font == 0) {
    if ((font = gdk_font_load ("-adobe-times-medium-r-normal-*-10-*-*-*-p-*-iso8859-1")) == 0)
      g_warning (_("Cannot load -adobe-times-medium-r-normal-*-10-*-*-*-p-*-iso8859-1 font\n"));
    /* Display text when new mail or error */
  }
  else
    gdk_draw_text (DA->window, font, myGC, 2, height-font->descent, unread, strlen (unread));

  /* Set window position */
  gdk_window_get_size (biff->window->window, &width, &height);
  if (biff->windowX < 0)
    x = gdk_screen_width()  - width  + biff->windowX;
  else
    x = biff->windowX;
  if (biff->windowY < 0)
    y = gdk_screen_height() - height + biff->windowY; 
  else
    y = biff->windowY;
  gtk_widget_set_uposition (biff->window, x, y);
};
