/*rtscall.h -- interface for rtscall.c
  Copyright (C) 1997-2002 Free Software Foundation, Inc.

  Authors: Jukka Virtanen <jtv@hut.fi>
           Peter Gerwinski <peter@gerwinski.de>
           Frank Heckenbach <frank@pascal.gnu.de>

  This file is part of GNU Pascal.

  GNU Pascal is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2, or
  (at your option) any later version.

  GNU Pascal is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Pascal; see the file COPYING. If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA. */

/* Allow multiple inclusion to work. */

#ifndef _GPC_RTS_CALL_H_
#define _GPC_RTS_CALL_H_

/* Include files needed by this one. */


/* Structure definitions. */

#define RTS_NORETURN 1
#define RTS_CONST    2

struct rts_symbol
{
  int val;
  char *name;
  rtx symref;
  tree fun;
  int io_critical;
  int attribute;
};

/* Simple definitions and enumerations. */


/* Typedefs. */


/* Include files needed by this one. */


/* Structure definitions. */


/* Global objects accessed by users of this module. */
extern int allow_packed_var_parameters;
extern struct rts_symbol rts[];
extern tree ptype_int; /* @@ Shouldn't be needed in the parser */

/* RTS calls */
extern tree do_ptype PARAMS ((tree, int, int));
extern tree ptype_set PARAMS ((int, tree));
extern tree actual_set_parameters PARAMS ((tree));
extern void declare_rts_types PARAMS ((void));
extern tree rts_call PARAMS ((int, tree, tree, tree));
extern tree build_rts_call PARAMS ((int, tree));

/* File I/O */
extern tree build_buffer_ref PARAMS ((tree, int));
extern tree get_standard_input PARAMS ((void));
extern tree get_standard_output PARAMS ((void));
extern tree get_standard_error PARAMS ((void));

/* Miscellaneous */
extern tree get_builtin_variable PARAMS ((char *, tree));

/* Declare functions with prototypes. */


/* Define macros. */

/* End of #include file. */

#endif /* _GPC_RTS_CALL_H_ */
