(*
This fails under DJGPP with `-g'. It is triggered by the use of two
identifiers with asmname `a' (though in different scopes).

g:/.\cchaaaaa: Assembler messages:
g:/.\cchaaaaa:190: Fatal error: C_EFCN symbol out of scope

The problem can be reproduced in C (compiled with `-g' under DJGPP):

int a = 42;

void c ()
{
  void a () {}
}

But in fact it seems to be a gas problem (actually, it seems to
depend on the gas version: with 2.11, it occurs only if the variable
is initialized; with 2.9.5 it occurs only if it's not initialized.
The comment in gas/config/obj-coff.c (before the second occurrence
of `C_EFCN symbol out of scope') is not very promising, either.

Bottom line:

Apparently COFF doesn't work well with local functions WRT debug
info. DJGPP depends on COFF and "chances are [switching to ELF as
DJGPP's object file format] will never happen" (DJGPP FAQ, edition
2.30, 22.22). So, if you get this problem, just don't use `-g' or
rename your identifiers ... :-/
*)

(* `--no-inline-functions' is needed to provoke the problem
   (otherwise the procedures `a' and `aa' might get optimized away),
   `-g0' is there to avoid it again (see above). ;-) *)
(* FLAG --no-inline-functions -g0 *)

program fjf500;

var
  a: Integer = 42;
  aa: Integer;

procedure b;
begin
end;

procedure c;

  procedure a;
  begin
  end;

  procedure aa;
  begin
  end;

begin
end;

begin
  a := a;
  aa := aa;
  WriteLn ('OK')
end.
