{ Test of the Pipe unit. }

program PipeTest2;

uses GPC, Pipe;

const
  ResultMessage : array [TWaitPIDResult] of TString =
    ('did not terminate with status ',
     'terminated with status ',
     'was teminated by signal ',
     'was stopped by signal ',
     'did something unexpected with status ');

var
  ToInput, f : Text;
  Process : PPipeProcess;
  WaitPIDResult : TWaitPIDResult;
  Status : Integer;
  IsEOF : Boolean;
  Result : TString;
  Parameters : TPStrings (2) = (@ShellExecCommand, @'exit 42');

begin
  {$I-}
  Pipe (ToInput, f, f, GetEnv (ShellEnvVar), Parameters, GetCEnvironment, Process, nil);
  {$I+}
  if InOutRes <> 0 then
    begin
      WriteLn ('Could not create pipe: ', GetIOErrorMessage);
      Halt (1)
    end;
  Process^.Result := @WaitPIDResult;
  Process^.Status := @Status;
  Close (ToInput);
  IsEOF := EOF (f);
  if not IsEOF then ReadLn (f, Result);
  Close (f);
  if not IsEOF then
    WriteLn ('Unexpected output `', Result, '''')
  else if (WaitPIDResult = PIDExited) and (Status = 42) then
    WriteLn ('OK')
  else
    WriteLn ('The process ', ResultMessage [WaitPIDResult], Status, '.');
end.
