/* Checker stubs for functions defined in unistd.h
   Copyright 1995, 1996 Tristan Gingold
		  Written December 1995 by Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

 The author may be reached by US/French mail:
		Tristan Gingold 
		8 rue Parmentier
		F-91120 PALAISEAU
		FRANCE
*/
#include "available-stubs.h"
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_CRYPT_H
#include <crypt.h>
#endif
#include "checker_api.h"

#undef HAVE_encrypt
#undef HAVE_setkey

#ifdef HAVE_crypt
char * chkr_stub_crypt (const char *key, const char *salt)
  __asm__ (CHKR_PREFIX ("crypt"));
char *
chkr_stub_crypt (const char *key, const char *salt)
{
  char *res;
  int len;

  stubs_chkr_check_addr (salt, 2, CHKR_RO, "salt");
  /* FIXME: check only the first 8 chars ?.  */
  stubs_chkr_check_str (key, CHKR_RO, "key");

  res = crypt (key, salt);
  len = strlen (res);
  stubs_chkr_set_right (res, len + 1, CHKR_RW);
  return res;
}
#endif /* HAVE_crypt */

#ifdef HAVE_encrypt
void chkr_stub_encrypt (char * arg0, int arg1)
  __asm__ (CHKR_PREFIX ("encrypt"));
void
chkr_stub_encrypt (char * arg0, int arg1)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (encrypt);
#else
  encrypt (arg0, arg1);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_encrypt */

#ifdef HAVE_setkey
void chkr_stub_setkey (const char * arg0) __asm__ (CHKR_PREFIX ("setkey"));
void
chkr_stub_setkey (const char * arg0)
{
  /* This function requires a stub */
  stubs_chkr_check_addr (arg0, sizeof (char), CHKR_XX);
#if USE_BI_JUMP
  __builtin_jump (setkey);
#else
  setkey (arg0);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_setkey */

