#include "available-stubs.h"

#include <stropts.h>
#include "checker_api.h"

/* compiled from: . */

#ifdef HAVE_isastream
/* From `/usr/include/stropts.h:25'.  */
int chkr_stub_isastream (int fd) __asm__ (CHKR_PREFIX ("isastream"));
int
chkr_stub_isastream (int fd)
{
#if USE_BI_JUMP
  __builtin_jump (isastream);
#else
  return isastream (fd);
#endif /* !USE_BI_JUMP */
}
#endif /* HAVE_isastream */

#define READ 0
#define WRITE 1
#define BEFORE_CALL 0
#define AFTER_CALL 1

#ifdef HAVE_chkr_func
void
chkr_check_struct_strbuf (struct strbuf *ptr, int rw, int ba)
{
  if (rw == READ)
    {
      if  (ba == BEFORE_CALL)
	{
	  stubs_chkr_check_addr (&ptr->maxlen, sizeof (ptr->maxlen), CHKR_RO,
				 "->maxlen");
	  if (ptr->maxlen > 0)
	    {
	      stubs_chkr_check_addr (&ptr->buf, sizeof (ptr->buf), CHKR_RO,
				     "->buf");
	      stubs_chkr_check_addr (&ptr->len, sizeof (ptr->len), CHKR_TW,
				     "->len");
	      stubs_chkr_check_addr (ptr->buf, ptr->maxlen, CHKR_MW, "buf");
	    }
	}
      else
	{
	  if (ptr->maxlen > 0)
	    {
	      stubs_chkr_check_addr (&ptr->len, sizeof (ptr->len), CHKR_WO,
				     "->len");
	      stubs_chkr_set_right (ptr->buf, ptr->len, CHKR_RW);
	    }
	}
    }
  else
    {
      stubs_chkr_check_addr (&ptr->len, sizeof (ptr->len), CHKR_RO,
			     "->len");
      stubs_chkr_check_addr (&ptr->buf, sizeof (ptr->buf), CHKR_RO,
			     "->buf");
      stubs_chkr_check_addr (ptr->buf, ptr->len, CHKR_RO, "buf");
    }
}
#else
void chkr_check_struct_strbuf (struct strbuf *ptr, int rw, int ba);
#endif /* HAVE_chkr_func */

#ifdef HAVE_getmsg
/* From `/usr/include/stropts.h:27'.  */
int chkr_stub_getmsg (int fd, struct strbuf *ctlptr, struct strbuf *dataptr,
		      int *flagsp)
     __asm__ (CHKR_PREFIX ("getmsg"));
int
chkr_stub_getmsg (int fd, struct strbuf *ctlptr, struct strbuf *dataptr,
		  int *flagsp)
{
  int res;

  fd_used_by_prog (fd);

  if (ctlptr)
    chkr_check_struct_strbuf (ctlptr, READ, BEFORE_CALL);

  if (dataptr)
    chkr_check_struct_strbuf (dataptr, READ, BEFORE_CALL);

  stubs_chkr_check_addr (flagsp, sizeof (int), CHKR_RW, "flagsp");

  res = getmsg (fd, ctlptr, dataptr, flagsp);
  if (res >= 0)
    {
      if (ctlptr)
	chkr_check_struct_strbuf (ctlptr, READ, AFTER_CALL);
      
      if (dataptr)
	chkr_check_struct_strbuf (dataptr, READ, AFTER_CALL);
    }
    
  return res;
}
#endif /* HAVE_getmsg */

#ifdef HAVE_putmsg
/* From `/usr/include/stropts.h:27'.  */
int chkr_stub_putmsg (int fd, struct strbuf *ctlptr, struct strbuf *dataptr,
		      int flagsp)
     __asm__ (CHKR_PREFIX ("putmsg"));
int
chkr_stub_putmsg (int fd, struct strbuf *ctlptr, struct strbuf *dataptr,
		  int flagsp)
{
  fd_used_by_prog (fd);

  if (ctlptr)
    chkr_check_struct_strbuf (ctlptr, WRITE, BEFORE_CALL);

  if (dataptr)
    chkr_check_struct_strbuf (dataptr, WRITE, BEFORE_CALL);

  return putmsg (fd, ctlptr, dataptr, flagsp);
}
#endif /* HAVE_putmsg */

#ifdef HAVE_getpmsg
/* From `/usr/include/stropts.h:30'.  */
int chkr_stub_getpmsg (int fd, struct strbuf *ctlptr, struct strbuf *dataptr,
		       int *bandp, int *flagsp)
     __asm__ (CHKR_PREFIX ("getpmsg"));
int
chkr_stub_getpmsg (int fd, struct strbuf *ctlptr, struct strbuf *dataptr,
		   int *bandp, int *flagsp)
{
  int res;

  fd_used_by_prog (fd);

  if (ctlptr)
    chkr_check_struct_strbuf (ctlptr, READ, BEFORE_CALL);

  if (dataptr)
    chkr_check_struct_strbuf (dataptr, READ, BEFORE_CALL);

  stubs_chkr_check_addr (bandp, sizeof (int), CHKR_RW, "bandp");
  stubs_chkr_check_addr (flagsp, sizeof (int), CHKR_RW, "flagsp");

  res = getmsg (fd, ctlptr, dataptr, flagsp);
  if (res >= 0)
    {
      if (ctlptr)
	chkr_check_struct_strbuf (ctlptr, READ, AFTER_CALL);
      
      if (dataptr)
	chkr_check_struct_strbuf (dataptr, READ, AFTER_CALL);
    }
    
  return res;
}
#endif /* HAVE_getpmsg */

#ifdef HAVE_putpmsg
/* From `/usr/include/stropts.h:31'.  */
int chkr_stub_putpmsg (int fd, struct strbuf *ctlptr, struct strbuf *dataptr,
		       int bandp, int flagsp)
     __asm__ (CHKR_PREFIX ("putpmsg"));
int
chkr_stub_putpmsg (int fd, struct strbuf *ctlptr, struct strbuf *dataptr,
		   int bandp, int flagsp)
{
  fd_used_by_prog (fd);

  if (ctlptr)
    chkr_check_struct_strbuf (ctlptr, WRITE, BEFORE_CALL);

  if (dataptr)
    chkr_check_struct_strbuf (dataptr, WRITE, BEFORE_CALL);

  return putpmsg (fd, ctlptr, dataptr, bandp, flagsp);

}
#endif /* HAVE_putpmsg */

