# MySQL dump 7.1
#
# Host: localhost    Database: gcdb
#--------------------------------------------------------
# Server version	3.22.32-log

#
# Table structure for table 'Accounts'
#
DROP TABLE IF EXISTS Accounts;
CREATE TABLE Accounts (
  AccountID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  CustomerID int(10) unsigned,
  Username varchar(50),
  Password varchar(50),
  Description varchar(100),
  DateOpened date,
  DateClosed date,
  Price float(5,2),
  Status varchar(25),
  Charged varchar(15) DEFAULT '' NOT NULL,
  TaxRate float(6,4),
  PRIMARY KEY (AccountID),
  UNIQUE AccountID (AccountID)
);

#
# Table structure for table 'Configuration'
#
DROP TABLE IF EXISTS Configuration;
CREATE TABLE Configuration (
  Version varchar(50),
  BillAhead enum('On','Off'),
  Language varchar(50),
  SameMonth enum('On','Off'),
  SearchBar enum('On','Off'),
  Anniversary enum('On','Off'),
  Name varchar(100),
  TaxRate float(6,4),
  BillFromAddress varchar(100),
  BillReplyAddress varchar(100),
  BillSubject varchar(100),
  BillHeader text,
  BillFooter text
);

#
# Dumping data for table 'Configuration'
#

LOCK TABLES Configuration WRITE;
INSERT INTO Configuration VALUES ('1.1.5','Off','english.php','On','On','Off','gcdb',0.0800,'changme','changme','gcdb Invoice','The following is an invoice for your account.','Thank you for your business!');
UNLOCK TABLES;

#
# Table structure for table 'Customers'
#
DROP TABLE IF EXISTS Customers;
CREATE TABLE Customers (
  CustomerID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  First varchar(30),
  Mid char(1),
  Last varchar(40),
  Address varchar(255),
  Telephone varchar(16),
  Fax varchar(16),
  Email varchar(100),
  City varchar(50),
  State char(2),
  Zip varchar(10),
  Balance float(6,2),
  CCNumber varchar(20),
  CCName varchar(80),
  Password varchar(50),
  Company varchar(100),
  CCExpire varchar(10),
  PRIMARY KEY (CustomerID),
  UNIQUE id (CustomerID)
);

#
# Table structure for table 'Invoices'
#
DROP TABLE IF EXISTS Invoices;
CREATE TABLE Invoices (
  InvoiceID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  CustomerID int(10) unsigned DEFAULT '0' NOT NULL,
  Description varchar(100),
  DateBilled date,
  Amount float(5,2),
  PRIMARY KEY (InvoiceID),
  UNIQUE InvoiceID (InvoiceID)
);

#
# Table structure for table 'Payments'
#
DROP TABLE IF EXISTS Payments;
CREATE TABLE Payments (
  PaymentID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  CustomerID int(10) unsigned DEFAULT '0' NOT NULL,
  DatePaid date,
  Type varchar(10),
  Number varchar(50),
  Amount float(5,2),
  PRIMARY KEY (PaymentID),
  UNIQUE PaymentID (PaymentID)
);

#
# Table structure for table 'Tickets'
#
DROP TABLE IF EXISTS Tickets;
CREATE TABLE Tickets (
  TicketID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  CustomerID int(10) unsigned DEFAULT '0' NOT NULL,
  Description text,
  Status varchar(10),
  OpenDate date,
  OpenTime time,
  CloseDate date,
  CloseTime time,
  Opener varchar(100),
  PRIMARY KEY (TicketID),
  UNIQUE TicketID (TicketID)
);

#
# Table structure for table 'Users'
#
DROP TABLE IF EXISTS Users;
CREATE TABLE Users (
  UserID int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  Username varchar(50),
  Password varchar(50),
  RealName varchar(100),
  Language varchar(50),
  Admin enum('Yes','No'),
  PRIMARY KEY (UserID)
);

#
# Dumping data for table 'Users'
#

LOCK TABLES Users WRITE;
INSERT INTO Users VALUES (1,'admin','admin','Administrator','english.php','Yes');
UNLOCK TABLES;

