<?
# This file contains lost of functions used by the billing database
# to generate no fun things like tables, forms, and such.
require("gcdb-settings.php");

if(!(extension_loaded("mysql"))) {
	die ("MySQL support not enabled, <b>gcdb</b> cannot run.");
}

###############################################################################
# DB FUNCTIONS
###############################################################################

# getDBConnection
#
# I did this so the DB could easily be changed
function getDBConnection () {
	global $PERSISTENT, $DBHOST, $DBUSER, $DBPASSWORD, $DBNAME;

	if($PERSISTENT == "On") {
		$db = mysql_pconnect($DBHOST, $DBUSER, $DBPASSWORD);
	} else {
		$db = mysql_connect($DBHOST, $DBUSER, $DBPASSWORD);
	}
	mysql_select_db($DBNAME, $db);
	checkMySQLError();
	return $db;
}

# checkMySQLError
#
# Checks for an error with MySQL and prints the error if it exists
function checkMySQLError () {
	$test = mysql_errno();
	if($test != 0) {
		echo mysql_errno().":".mysql_error()."<br>";
	}
}

# mysqlReport
#
# Uses the PrettyTable functions to generate a table detailing what happened
function mysqlReport ($result, $title, $return_url, $return_link) {
	global $lUpdateSuccess, $lUpdateFailed;
	if($result == 1) {
		beginPrettyTable("1", $title);
		echo "<tr>\n";
		echo " <td><div class=data>$lUpdateSuccess <a href='$return_url'>$return_link</a></div></td>\n";
		echo "</tr>\n";
		endPrettyTable();
	} else {
		beginPrettyTable("1", $title);
		echo "<tr> <td><div class=data>$lUpdateFailed: ";
		echo mysql_error();
		echo "</div></td></tr>\n";
		endPrettyTable();
	}
}

###############################################################################
# BILLING FUNCTIONS
###############################################################################

# get_running_months
#
# counts the number of months an account has been open
function get_running_months($open_date, $close_date, $same_month, $anniversary) {
	$open_date_array = explode("-", $open_date);
	$close_date_array = explode("-", $close_date);
	$current_year = date("Y");
	$current_day = date("d");
	$current_month = date("m");

	# If same month is on and it's the 25th or later, give them a free
	# month.
	if($same_month == "On") {
		if($open_date_array[2] >= 25) {
			$running_months = -1;
		} else {
			$running_months = 0;
		}
	} else {
		$running_months = 0;
	}

	# If anniversary billing is on and the we haven't hit the day yet
	# lop off one month
	if($anniversary == "On") {
		if($open_date_array[2] < $current_day) {
				$running_months += -1;
		}
	}	

	if($close_date_array[0] == "0000") {
		$years = $current_year - $open_date_array[0];
		if($years != 0) {
			$months = (12 - $open_date_array[1]) + $current_month; 
		}
		if($years > 1) {
			$years--;
			$running_months += ($years * 12);
		}
		if($open_date_array[0] == $current_year) {
			$months = $current_month - $open_date_array[1];
		}
		if($months > 0) {
			$running_months += $months;
		}
		if($running_months < 0) {
			$running_months = 0;
		}
		return($running_months);
	} else {
		$years = $close_date_array[0] - $open_date_array[0];
		$months = $close_date_array[1] - $open_date_array[1];

		if($years > 0) {
			$running_months += (($years * 12) - ($open_date_array[1] - $close_data_array[1]));
		}
		if($months > 0) {
			$running_months += $months;
		}
		if($running_months < 0) {
			$running_months = 0;
		}

		return($running_months);
	}
}

# get_total_price
#
# gets the total price for the account
function get_total_price($price, $taxrate, $charged, $months, $billahead) {
	if($charged == "monthly") {
		$divider = 1;
	}
	if($charged == "quarterly") {
		$divider = 3;
	}
	if($charged == "biannually") {
		$divider = 6;
	}
	if($charged == "annually") {
		$divider = 12;
	}
	$timearoo = (integer)($months / $divider);
	if($billahead == "On") {
		$timearoo += $divider;
	}
	$total_price = $timearoo * $price;
	if($taxrate > 0) {
		$total_price += ($total_price * $taxrate);
	}
	return($total_price);
}

###############################################################################
# DOCUMENT FUNCTIONS
###############################################################################

# beginDocument 
#
# echos the HTML tags that get the document started, provides a central
# location for the background color, stylesheets, and whatnot.
function beginDocument ($title, $user) {
	global $BRAND, $BACKGROUND, $TOPBAR;

	echo "<html>\n";
	echo "<head>\n <title>[$BRAND] :: $title</title>\n";
	echo " <link rel=stylesheet href='gcdb.css' type='text/css'>\n";
	echo "</head>\n<body bgcolor='$BACKGROUND' text='black' leftmargin=0 topmargin=0 marginheight=0 marginwidth=0>\n"; 
	echo "<table bgcolor='$TOPBAR' width=100%><tr><td width='80%' align='left' class='header'>&nbsp;&nbsp;$BRAND: $user</td><td width='20%' align='right'>";
	if($user != "Not Logged In") {
  	echo "<a href='main.php'><img src='images/home.gif' width=24 height=24 border=0 alt='Home'></a>";
	}
  echo "&nbsp;&nbsp;</td></tr></table>";
	echo "<table cellpadding=10 width='100%' height='100%' border=0><tr><td valign=top>\n";
}

# searchBar
#
# echos the HTML for the search Bar
function searchBar() {
	global $lSearch, $lLast, $lAddress, $lEmail;
	openForm("searcher", "search.php");
		beginPrettyTable("2");
		echo "<tr><td>\n";
		echo "<b>$lSearch</b>: <input name='tosearch' type='text'>\n";
		echo "</td><td valign='center'>\n";
		echo "<select name='searcher' type='text'>\n";
		echo " <option value='last'>$lLast\n";
		echo " <option value='address'>$lAddress\n";
		echo " <option value='email'>$lEmail\n";
		echo "</select>\n";
		echo "<input type='image' align='center' src='images/go.gif' value='submit' border=0>\n";
		echo "</td></tr>\n";
		endPrettyTable();
		closeForm();
}

# endDocument
# 
# closes all the HTML opened by beginDocument
function endDocument() {
	echo "</td></tr></table></body></html>\n";
}
	

###############################################################################
# TABLE FUNCTIONS
###############################################################################

# beginPrettyTable
#
# handle the creation of a pretty, outlined table.  Uses the supplied
# bordercolor, bgcolor, colspan (for header) and text (text of header)
function beginPrettyTable () {
	global $TABLEBORDER, $INNERTABLE;

	# Allow us to take either 1 or 2 arguments
	$numargs = func_num_args();
	if($numargs == 0) {
		die ("Must provide a colspan to beginPrettyTable()\n");
	}
	$arg_list = func_get_args();
	for($i = 0; $i < $numargs; $i++) {
		if($i == 0) {
			$colspan = $arg_list[$i];
		}
		if($i == 1) {
			$header = $arg_list[$i];
		}
	}
	echo "<table bgcolor='$TABLEBORDER' cellpadding=1 cellspacing=0 border=0>\n";
	if ($header) {
		echo " <tr> <td colspan=$colspan align=right><div class='header'>$header&nbsp;</div></td> </tr>\n";
	}
	echo " <tr>\n  <td>\n";
	echo "   <table bgcolor='$INNERTABLE' cellpadding=2 cellspacing=0 border=0>\n";
	echo "    <tr>\n  <td>\n";
	echo "      <table bgcolor='$INNERTABLE' cellpadding=2 cellspacing=0 border=0>\n";
}

# endPrettyTable
#
# close all tags opened by beginPrettyTable
function endPrettyTable () {
	echo "      </table>\n";
	echo "     </td> </tr>\n";
	echo "   </table>\n";
	echo "  </td> </tr>\n";
	echo "</table>\n";
}

# beginBorderedTable
#
# when used in unison with beginPrettyTable, gives a nice visual cue around
# the data inside a table
function beginBorderedTable ($colspan) {
	global $TABLEBORDER, $INNERTABLE;

	echo "<tr>\n  <td>\n";
	echo " <table bgcolor='$INNERTABLE' cellpadding=2 cellspacing=2 border=0>\n";
}

# endBorderedTable
#
# close all tags opened by beginBorderedTable
function endBorderedTable () {
	echo "   </td> </tr>\n";
	echo "  </table>\n";
	echo " </td> </tr>\n";
}

###############################################################################
# FORM FUNCTIONS
###############################################################################

# openForm
#
# creates a form
function openForm ($name, $action) {
	echo "<form method='post' name='$name' action='$action'>";
}

# makeHiddenField
#
# creates a hidden field
function makeHiddenField ($field, $value) {
	echo "<input type=\"hidden\" name=\"$field\" value=\"$value\">\n";
}

# makeStaticField
#
# creates an uneditable field
function makeStaticField ($field, $value) {
	echo " <tr> <td><b>$field:</b></td><td><div class='data'>$value</div></td> </tr>\n";
}

# makeTextField
#
# creates a textfield with the supplied paramaters
function makeTextField ($field, $name, $value) {
	echo " <tr> <td><b>$field:</b></td><td><input name='$name' type='text' value='$value'></td> </tr>\n";
}

# makeLargeTextField
#
# creates a textarea with the supplied parameters
function makeLargeTextField ($field, $name, $value) {
	echo "<tr> <td valign='top'><b>$field:</b></td><td><textarea name=$name cols='48' rows='15' wrap='physical'>$value</textarea></td></tr>\n";
}

# makeDropBox
#
# creates a <select> control using the supplied options, rearranging them
# according to the first arg passed
function makeDropBox () {
	$numargs = func_num_args();
	if($numargs < 3) {
		echo $numargs."-";
		die ("Must provide arguments to makeDropBox\n");
	}
	$arg_list = func_get_args();
	$field 	= $arg_list[0];
	$name 	= $arg_list[1];
	$current= $arg_list[2];
	echo " <tr> <td><b>$field:</b></td><td><select name='$name'>\n";
	echo "<option value='$current'>$current\n";
	for($i = 3; $i < $numargs; $i++) {
		if($arg_list[$i] != $current) {
			echo "<option value='$arg_list[$i]'>$arg_list[$i]\n";
		}
	}
	echo "</select></td></tr>\n";
}

# makeSubmitter
#
# makes a submit field
function makeSubmitter () {
	echo " <tr> <td colspan=2 align=center>\n";
	echo "  <input type=image type='submit' value='submit' src='images/submit.gif' border=0 alt='Go!'>";
	echo " </td> </tr>\n";
}

# closeForm
#
# close a form
function closeForm () {
	echo "</form>";
}

###############################################################################
# LANGUAGES
###############################################################################

if(!(isset($sess_lang))) {
 	$db = getDBConnection();
 	$result = mysql_query("select * from Configuration");
	$config_row = mysql_fetch_array($result);
	require("lang/".$config_row["Language"]);
} else {
	require("lang/".$sess_lang);
}

?>
