/*
 * GChangepass -- GTK+ Frontend to passwd
 * Copyright (C) 2005 Guilherme de Siqueira Pastore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <pwd.h>
#include <unistd.h>
#include "config.h"
#include "gchangepass.h"
#include "misc.h"
#include "ui.h"


UserData *_userdata;
Internals *_internals;

static void gchangepass_clean (void)
{
  g_free (_userdata->user);
  secure_free (_userdata->current_password);
  secure_free (_userdata->new_password);
  g_free (_userdata);
}

void gchangepass_exit (gint exitcode)
{
  gchangepass_clean ();
  exit (exitcode);
}

int main (gint argc, gchar **argv)
{
  gint uid = getuid ();
  struct passwd *user = getpwuid (uid);

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE_NAME, LOCALEDIR);  
  bind_textdomain_codeset (PACKAGE_NAME, "UTF-8");
  textdomain (PACKAGE_NAME);

  gtk_init (&argc, &argv);

  _internals = g_new (Internals, 1);
  _internals->uid = uid;

  _userdata = g_new (UserData, 1);
  _userdata->user = g_strdup (user->pw_name);
  _userdata->current_password = NULL;
  _userdata->new_password = NULL;

  if (uid == 0)
    {
      gchangepass_ask_root ();
      gtk_main ();
    }
  else
    gchangepass_query (CURRENT);

  gchangepass_clean ();

  return 0;
}
