/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

#include "fileops.h"

extern GladeXML *xml;
extern GString *GLADE_FILE;
extern GList *ComicList;

extern gchar *current_filename;
extern gboolean file_changed;

extern gchar *MainWindowKey;
extern gchar *ComicListKey;
extern gchar *ComicToAddKey;
extern gchar *ComicToAddToKey;
extern gchar *ComicToEditKey;
extern gchar *IssueToEditKey;

/* function prototypes - START */
gboolean on_export_file_selection_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_export_file_selection_cancel_button_clicked (GtkButton *button, gpointer user_data);
void on_export_file_selection_ok_button_clicked (GtkButton *button, gpointer user_data);
void connect_export_file_selection_signals (GladeXML *temp_xml);
void real_export_file(GtkWidget *main_window, GString *fname);
/* function prototypes - END */

/* callback functions - START */
gboolean on_export_file_selection_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  GtkWidget *export_file_selection;
  GladeXML *temp_xml = user_data;

  export_file_selection = glade_xml_get_widget (temp_xml, "export_file_selection");
  gtk_widget_destroy (export_file_selection);

  return FALSE;
}

void on_export_file_selection_cancel_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *export_file_selection;
  GladeXML *temp_xml = user_data;

  export_file_selection = glade_xml_get_widget (temp_xml, "export_file_selection");
  gtk_widget_destroy(export_file_selection);
}

void on_export_file_selection_ok_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *main_window, *export_file_selection;
  GString *fname;
  GladeXML *temp_xml = user_data;

  export_file_selection = glade_xml_get_widget (temp_xml, "export_file_selection");
  main_window = gtk_object_get_data (GTK_OBJECT (export_file_selection), MainWindowKey);

  /* FIXME - very ugly hack to make sure sufficient space is allocated for current_filename */
  fname = g_string_new(NULL);
  g_string_sprintf(fname, "%s", gtk_file_selection_get_filename (GTK_FILE_SELECTION (export_file_selection)));

  real_export_file(main_window, fname);

  gtk_widget_destroy(export_file_selection);
}
/* callback functions - END */


void real_export_file(GtkWidget *main_window, GString *fname)
{
  FILE *fp;

  fp = fopen (fname->str, "w");
  if (fp == NULL)
    {
      gnome_app_flash(GNOME_APP(main_window), "Unable to export file.");
      return;
    }
  ExportToASCIIFile(ComicList, fp);
  gnome_app_flash(GNOME_APP(main_window), "File exported.");
  fclose(fp);
}

void connect_export_file_selection_signals (GladeXML *temp_xml)
{
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "ok_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_export_file_selection_ok_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "cancel_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_export_file_selection_cancel_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "export_file_selection")), "delete_event",
			   GTK_SIGNAL_FUNC(on_export_file_selection_delete_event), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
}

/* exported functions - START */
void create_export_file_selection (GtkWidget *generic)
{
  GtkWidget *main_window, *export_file_selection = NULL;
  GladeXML *temp_xml;
 
  main_window = glade_xml_get_widget (xml, "main_window");

  temp_xml = glade_xml_new (GLADE_FILE->str, "export_file_selection");
  export_file_selection = glade_xml_get_widget (temp_xml, "export_file_selection");

  connect_export_file_selection_signals (temp_xml);

  gtk_object_set_data (GTK_OBJECT (export_file_selection), MainWindowKey, main_window);
  gtk_widget_show (export_file_selection);
}
/* exported functions - END */
