/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>
#include <gmodule.h>
#include <stdlib.h>

#include "comiclist.h"
#include "fileops.h"

extern GladeXML *xml;
extern GString *GLADE_FILE;
extern GList *ComicList;

extern gchar *current_filename;
extern gboolean file_changed;

extern gchar *MainWindowKey;
extern gchar *ComicListKey;
extern gchar *ComicToAddKey;
extern gchar *ComicToAddToKey;
extern gchar *ComicToEditKey;
extern gchar *IssueToEditKey;

extern GList *publisher_history;
extern GList *type_history;
extern GList *group_history;

extern GList *cover_price_history;
extern GList *current_price_history;
extern GList *purchase_price_history;

extern GList *location_history;

extern GList *writer_history;
extern GList *penciler_history;
extern GList *inker_history;

/* preferences - START */
extern gboolean auto_fill_issue;

extern gboolean show_number_title;
extern gboolean show_location_title;
extern gboolean show_condition_title;
extern gboolean show_cover_price_title;
extern gboolean show_current_price_title;
extern gboolean show_purchase_price_title;
/* preferences - END */



char *itoa(int i)
{ char *a;
  a = (char *)malloc(10);
  sprintf(a,"%i",i);
  return a;
}


GList *get_selected_issue (GtkWidget *generic)
{
  GtkCList *issues_clist = GTK_CLIST (glade_xml_get_widget (xml, "issues_clist"));
  return issues_clist->selection;
}

GList *get_selected_title (GtkWidget *generic)
{
  GtkWidget *comics_tree = glade_xml_get_widget (xml, "comics_tree");
  return GTK_TREE_SELECTION (comics_tree);
}

void exp_set_selected_title (GtkWidget *window, TComic *comic_title)
{
  gint index = g_list_index(ComicList, comic_title);
  GtkWidget *comics_tree = glade_xml_get_widget (xml, "comics_tree");
  gtk_tree_select_item(GTK_TREE(comics_tree), index);
}

void exp_set_selected_issue (GtkWidget *window, TComic *comic_title, TIssue *comic_issue)
{
  gint index = g_list_index(comic_title->IssueNumbers, comic_issue);

  GtkCList *issues_clist = GTK_CLIST (glade_xml_get_widget (xml, "issues_clist"));
  gtk_clist_select_row(issues_clist, index, 0);
}

gint gtk_clist_length (GtkCList *clist)  /* FIXME - very (!!!) ugly hack to get length of the CList */
{
  struct _GtkCList *p;

  p = clist;
  return g_list_length(p->row_list);
}

void clear_tree (GtkTree *tree)
{
  gtk_tree_clear_items(tree, 0, G_MAXINT); /* FIXME - very ugly hack to clear the entire list... */
}

void clear_clist (GtkCList *clist)
{
  gtk_clist_freeze(clist);
  gtk_clist_clear(clist);
  gtk_clist_thaw(clist);
}

void clear_text (GtkText *text)
{
  gtk_text_freeze(text);
  gtk_text_backward_delete(text, gtk_text_get_length(text));
  gtk_text_thaw(text);
}

void real_clear_list(GtkWidget *widget)
{
  GtkTree *comics_tree;
  GtkCList *issues_clist;
  GtkText *comics_info_text, *issues_info_text;
  GtkWidget *main_window;
  TComic *TempComic;
  TIssue *TempIssue;

  main_window = glade_xml_get_widget (xml, "main_window");
  comics_tree = GTK_TREE (glade_xml_get_widget (xml, "comics_tree"));
  issues_clist = GTK_CLIST (glade_xml_get_widget (xml, "issues_clist"));
  comics_info_text = GTK_TEXT (glade_xml_get_widget (xml, "comics_info_text"));
  issues_info_text = GTK_TEXT (glade_xml_get_widget (xml, "issues_info_text"));

  while (ComicList!=NULL)
    {
      TempComic = ComicList->data;
      while (TempComic->IssueNumbers!=NULL)
	{
	  TempIssue = TempComic->IssueNumbers->data;
	  TempComic->IssueNumbers = g_list_remove(TempComic->IssueNumbers, TempIssue);
	  g_free(TempIssue);
	}
      
      ComicList = g_list_remove(ComicList, TempComic);
      g_free(TempComic);
    }
  
  clear_tree(comics_tree);
  clear_clist(issues_clist);
  clear_text(comics_info_text);
  clear_text(issues_info_text);
  
  g_free(current_filename);
  current_filename = NULL;
  gtk_window_set_title (GTK_WINDOW (main_window), "GNOME Comics Organizer - Untitled");
  file_changed = FALSE;
}


void CreateComicsTreeList(GtkTree *comic_titles_tree, GList *clist)
{
  GtkWidget *tree_item;
  TComic *TempComic;
  GList *TempComicGList;
  gint i,j;
  GString *label;

  j=g_list_length(clist);
  clear_tree(comic_titles_tree);

  for(i=0;i<j;i++)
    {
      TempComicGList = g_list_nth(clist,i);
      TempComic = TempComicGList->data;

      label = g_string_new(TempComic->CTitle->str);
      
      if (strcmp(TempComic->CVolume->str,"1")) /* if volume!=1 then append volume to label*/
	{
	  label = g_string_append(label, " (Volume ");
	  label = g_string_append(label, TempComic->CVolume->str);
	  label = g_string_append(label, ")");
	}

      tree_item = gtk_tree_item_new_with_label(label->str);

      gtk_object_set_data (GTK_OBJECT (tree_item), ComicListKey, TempComicGList);

      gtk_tree_append(comic_titles_tree, tree_item);
      gtk_widget_show(tree_item);
    }
}

void AppendComicsTreeList(GtkTree *comics_tree, GList *clist)
{
  GtkWidget *tree_item;
  TComic *TempComic;
  GList *TempComicGList;
  gint index;
  GString *label;

  index = 0;

  TempComicGList = g_list_nth(clist, index);
  TempComic = TempComicGList->data;

  label = g_string_new(TempComic->CTitle->str);
      
  if (strcmp(TempComic->CVolume->str,"1")) /* if volume!=1 then append volume to label*/
  {
    label = g_string_append(label, " (Volume ");
    label = g_string_append(label, TempComic->CVolume->str);
    label = g_string_append(label, ")");
  }

  tree_item = gtk_tree_item_new_with_label(label->str);

  gtk_object_set_data (GTK_OBJECT (tree_item), ComicListKey, TempComicGList);

  gtk_tree_append(comics_tree, tree_item);
  gtk_widget_show(tree_item);
}
  
void CreateIssuesCList(GtkCList *issues_clist, GList *ilist)
{
  GList *TempIssueGList;
  TIssue *TempIssue;
  gint i,j, currentrow;
  gchar *issue_row[6];

  j=g_list_length(ilist);
  clear_clist(issues_clist);
  gtk_clist_freeze(issues_clist);
  for(i=0;i<j;i++)
    {
      TempIssueGList = g_list_nth(ilist,i);
      TempIssue = TempIssueGList->data;

      issue_row[0] = TempIssue->IssueNo->str;
      issue_row[1] = TempIssue->Location->str;
      issue_row[2] = ((Condition2GString(TempIssue->Condition))->str);
      issue_row[3] = TempIssue->Price->str;
      issue_row[4] = TempIssue->CurrentPrice->str;
      issue_row[5] = TempIssue->PurchasePrice->str;

      currentrow = gtk_clist_append(issues_clist, issue_row);
      gtk_clist_set_row_data(issues_clist, currentrow, TempIssueGList);
    }
  gtk_clist_thaw(issues_clist);
}

void display_selected_comic_title(GtkWidget *widget)
{
  TComic *TempComic;
  GList *TempComicGList;
  GtkText *comics_info_text, *issues_info_text;
  GtkCList *IssuesCList;
  GString *IssuesAmount;

  TempComicGList = gtk_object_get_data (GTK_OBJECT (widget), ComicListKey);
  if (!TempComicGList) return; /* no issues yet? */

  TempComic = TempComicGList->data;
  IssuesAmount = g_string_new(NULL);
  g_string_sprintf(IssuesAmount, "%i Issues", g_list_length(TempComic->IssueNumbers));

  comics_info_text = GTK_TEXT (glade_xml_get_widget(xml, "comics_info_text"));
  issues_info_text = GTK_TEXT (glade_xml_get_widget(xml, "issues_info_text"));

  clear_text(issues_info_text);
  clear_text(comics_info_text);
  gtk_text_freeze(comics_info_text);
  if (TempComic->IsLink)
    {
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, "Link to file: ", -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, TempComic->LinkFile->str, -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, "\n", -1);
    }
  else
    {
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, "Publisher: ", -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, TempComic->CPublisher->str, -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, "\n", -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, "Type: ", -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, TempComic->CType->str, -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, "\n", -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, IssuesAmount->str, -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, "\n", -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, "Comment: ", -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, TempComic->Comment->str, -1);
      gtk_text_insert(comics_info_text, NULL, NULL, NULL, "\n", -1);
    }
  gtk_text_thaw(comics_info_text);

  IssuesCList = GTK_CLIST (glade_xml_get_widget(xml, "issues_clist"));
  CreateIssuesCList(IssuesCList, TempComic->IssueNumbers);
}

void display_selected_issue_info(TIssue *TempIssue, GtkText *IssuesInfo)
{
  guint32 m,n;
  GString *String;

  clear_text(IssuesInfo);
  gtk_text_freeze(IssuesInfo);
  gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "Story Title(s):\n", -1);
  n=g_list_length(TempIssue->Title);
  for(m=0;m<n;m++)
    { 
      String = g_list_nth(TempIssue->Title, m)->data;
      gtk_text_insert(IssuesInfo, NULL, NULL, NULL, String->str, -1);
      gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "\n", -1);
    }
  gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "\n", -1);
  gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "Writer(s):\n", -1);
  n=g_list_length(TempIssue->Writer);
  for(m=0;m<n;m++)
    { 
      String = g_list_nth(TempIssue->Writer, m)->data;
      gtk_text_insert(IssuesInfo, NULL, NULL, NULL, String->str, -1);
      gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "\n", -1);
    }
  gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "\n", -1);
  gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "Penciler(s):\n", -1);
  n=g_list_length(TempIssue->Penciller);
  for(m=0;m<n;m++)
    { 
      String = g_list_nth(TempIssue->Penciller, m)->data;
      gtk_text_insert(IssuesInfo, NULL, NULL, NULL, String->str, -1);
      gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "\n", -1);
    }
  gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "\n", -1);
  gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "Inker(s):\n", -1);
  n=g_list_length(TempIssue->Inker);
  for(m=0;m<n;m++)
    { 
      String = g_list_nth(TempIssue->Inker, m)->data;
      gtk_text_insert(IssuesInfo, NULL, NULL, NULL, String->str, -1);
      if (n-m>1) gtk_text_insert(IssuesInfo, NULL, NULL, NULL, "\n", -1);
    }

  gtk_text_thaw(IssuesInfo);
}

void refresh_comics_list(GtkWidget *add_window)
{
  GtkTree *comic_titles_tree = GTK_TREE (glade_xml_get_widget (xml, "comics_tree"));

  /* redisplay the list of Comic Titles */
  CreateComicsTreeList(comic_titles_tree, ComicList);

  display_selected_comic_title(add_window);
}




gint StrCompare (gconstpointer a, gconstpointer b)
{
  const GString *GSa, *GSb;
  gint return_value;
  
  GSa = a;
  GSb = b;

  return_value = strcmp(GSa->str, GSb->str);

  return return_value;
}

GList *g_list_insert_str_sorted_unique (GList *history_list, GString *string_insert)
{
  GList *GLDup;

  GLDup = g_list_find_custom (history_list, string_insert, StrCompare);
  if (GLDup==NULL) /* no duplicate found */
    return g_list_insert_sorted (history_list, string_insert, StrCompare);
  else return (history_list);
}

GList *g_list_copy (GList *glist)
{
  GString *new_item, *item;
  GList *return_list = NULL;
  GList *p = glist;

  while (p!=NULL)
    {
      item = g_list_nth_data (p, 0);
      new_item = g_string_new (item->str);
      
      return_list = g_list_append (return_list, new_item);

      p = g_list_next (p);
    }

  return return_list;
}

GList *g_list_insert_glist_str_sorted_unique (GList *main_history_list, GList *insert_history_list)
{
  GList *p = insert_history_list;
  GString *item;

  while (p!=NULL)
    {
      item = g_list_nth_data (p, 0);
      main_history_list = g_list_insert_str_sorted_unique (main_history_list, item);

      p = g_list_next (p);
    }

  return main_history_list;
}




void prepend_one (gpointer data, gpointer user_data)
{
  GnomeEntry *gentry = user_data;
  GString *history_item = data;

  gnome_entry_prepend_history (gentry, FALSE, history_item->str);
}

void gnome_entry_set_history (GnomeEntry *gentry, GList *history_list)
{
  gnome_entry_set_history_id (gentry, NULL);

  g_list_foreach (history_list, prepend_one, gentry);
}

void save_history (gpointer data, gpointer user_data)
{
  gchar *path = user_data;
  GString *GSTemp = data;

  gnome_config_set_string (path, GSTemp->str);
}



void gnome_config_set_glist_str (gchar* path, GList *glist)
{
  int i = 0;
  GList *p = glist;
  GString *org_path, *ext_path, *item;

  ext_path = g_string_new (NULL);
  org_path = g_string_new (path);

  while (p!=NULL)
    {
      item = g_list_nth_data (p, 0);

      ext_path = g_string_assign (ext_path, org_path->str);
      ext_path = g_string_append_c (ext_path, '/');
      ext_path = g_string_append (ext_path, itoa(i));

      gnome_config_set_string (ext_path->str, item->str);
      
      i += 1;
      p = g_list_next (p);
    }
}

GList *gnome_config_get_glist_str (gchar* path)
{
  int i=0;
  GList *return_list = NULL;
  GString *org_path, *ext_path, *item;
  gchar *temp;
 
  ext_path = g_string_new (NULL);
  org_path = g_string_new (path);
 
  ext_path = g_string_assign (ext_path, org_path->str);
  ext_path = g_string_append_c (ext_path, '/');
  ext_path = g_string_append (ext_path, itoa(i));

  temp = gnome_config_get_string (ext_path->str);
  
  while (temp!=NULL)
    {
      item = g_string_new (temp);
      return_list = g_list_append (return_list, item);

      i += 1;

      ext_path = g_string_assign (ext_path, org_path->str);
      ext_path = g_string_append_c (ext_path, '/');
      ext_path = g_string_append (ext_path, itoa(i));
      
      temp = gnome_config_get_string (ext_path->str);
    }

  return return_list;
}



void save_prefs_and_history ()
{
  gnome_config_set_glist_str ("/gco/publisher_history", publisher_history);
  gnome_config_set_glist_str ("/gco/type_history", type_history);
  gnome_config_set_glist_str ("/gco/group_history", group_history);

  gnome_config_set_glist_str ("/gco/location_history", location_history);

  gnome_config_set_glist_str ("/gco/writer_history", writer_history);
  gnome_config_set_glist_str ("/gco/penciler_history", penciler_history);
  gnome_config_set_glist_str ("/gco/inker_history", inker_history);

  gnome_config_set_bool ("/gco/preferences/auto_fill_issue", auto_fill_issue);
  gnome_config_set_bool ("/gco/preferences/show_number_title", show_number_title);
  gnome_config_set_bool ("/gco/preferences/show_location_title", show_location_title);
  gnome_config_set_bool ("/gco/preferences/show_condition_title", show_condition_title);
  gnome_config_set_bool ("/gco/preferences/show_cover_price_title", show_cover_price_title);
  gnome_config_set_bool ("/gco/preferences/show_current_price_title", show_current_price_title);
  gnome_config_set_bool ("/gco/preferences/show_purchase_price_title", show_purchase_price_title);

  gnome_config_sync ();
}

void load_prefs_and_history ()
{
  publisher_history = gnome_config_get_glist_str ("/gco/publisher_history");
  type_history = gnome_config_get_glist_str ("/gco/type_history");
  group_history = gnome_config_get_glist_str ("/gco/group_history");
  
  location_history = gnome_config_get_glist_str ("/gco/location_history");
  
  writer_history = gnome_config_get_glist_str ("/gco/writer_history"); 
  penciler_history = gnome_config_get_glist_str ("/gco/penciler_history");
  inker_history = gnome_config_get_glist_str ("/gco/inker_history");

  auto_fill_issue = gnome_config_get_bool ("/gco/preferences/auto_fill_issue");
  show_number_title = gnome_config_get_bool_with_default ("/gco/preferences/show_number_title=true", NULL);
  show_location_title = gnome_config_get_bool ("/gco/preferences/show_location_title");
  show_condition_title = gnome_config_get_bool ("/gco/preferences/show_condition_title");
  show_cover_price_title = gnome_config_get_bool ("/gco/preferences/show_cover_price_title");
  show_current_price_title = gnome_config_get_bool ("/gco/preferences/show_current_price_title");
  show_purchase_price_title = gnome_config_get_bool ("/gco/preferences/show_purchase_price_title");
}
