/*
** Copyright (C) 10 Feb 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>

#include "common_gtk.h"
#include "mainwindow.h"
#include "cdrecord_options.h"
#include "audio.h"
#include "status_text.h"
#include "menu.h"
#include "locks.h"
#include "filepicker.h"
#include "verify.h"
#include "globals.h"

#define GCOM_USE_OLD_GTK GTK_CHECK_VERSION(1,2,5)

static GtkWidget *sc_win;

GtkWidget *mainwindow;
GtkTooltips *tooltips;

mainwindow_widgets *mainptr;

static int hide_tabs_count = 0;

static void destroy_win(GtkWidget *widget, gpointer data) {
	if (check_if_running())
		ask_really_sure();
	else
		exit_program();
}

void mainwindow_enable_tabs(void) {
	hide_tabs_count--;
	if (hide_tabs_count < 0) {
		g_warning("mainwindow_enable_tabs: hide_tabs_count < 0 (this is a bug)");
		hide_tabs_count = 0;
	}
	if (0 == hide_tabs_count) {
		gtk_widget_set_sensitive(mainptr->options, TRUE);	
		gtk_widget_set_sensitive(mainptr->filepicker, TRUE);	
		gtk_widget_set_sensitive(mainptr->audio, TRUE);	
		gtk_widget_set_sensitive(mainptr->burn_options, TRUE);	
		gtk_widget_set_sensitive(mainptr->menu, TRUE);	
	}
} 

void mainwindow_disable_tabs(void) {
	hide_tabs_count++;
	gtk_widget_set_sensitive(mainptr->options, FALSE);	
	gtk_widget_set_sensitive(mainptr->filepicker, FALSE);	
	gtk_widget_set_sensitive(mainptr->audio, FALSE);	
	gtk_widget_set_sensitive(mainptr->burn_options, FALSE);	
	gtk_widget_set_sensitive(mainptr->menu, FALSE);	
}

static GtkWidget *create_window() {
	GtkWidget *vbox, *menubar;

	mainptr = g_malloc0(sizeof(mainwindow_widgets));

	mainwindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(mainwindow), "gcombust");
	gtk_window_set_policy(GTK_WINDOW(mainwindow), TRUE, TRUE, FALSE);

	sc_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (sc_win),
			GTK_POLICY_NEVER, GTK_POLICY_NEVER);
	gtk_container_add(GTK_CONTAINER(mainwindow), sc_win);
	gtk_widget_show(sc_win);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sc_win), vbox);

	menubar = create_menu();
	gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, FALSE, 0);

	return vbox;
}

static GtkWidget *create_notebook(GtkWidget *win) {
	GtkWidget *notebook, *options_l, *filepicker_l, *burn_l, *audio_l, *combust_l;
	GtkWidget *options, *filepicker, *burn_options, *combust, *audio;
	GtkWidget *verify_l, *verify;
	config_cdr_data *cdr_info;

	notebook = gtk_notebook_new();
	gtk_widget_show(notebook);
	gtk_box_pack_start(GTK_BOX(win), notebook, TRUE, TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(notebook), 3);

	options_l = gtk_label_new(_("Options"));
	gtk_widget_show(options_l);
	options = make_frame(NULL, 1);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), options, options_l);

	filepicker_l = gtk_label_new(_("Data Files"));
	gtk_widget_show(filepicker_l);
	filepicker = make_frame(NULL, 1);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), filepicker, filepicker_l);

	audio_l = gtk_label_new(_("Audio Files"));
	gtk_widget_show(audio_l);
	audio = make_frame(NULL, 1);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), audio, audio_l);

	burn_l = gtk_label_new(_("Burn"));
	gtk_widget_show(burn_l);
	burn_options = make_frame(NULL, 1);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), burn_options, burn_l);

	combust_l = gtk_label_new(_("Output"));
	gtk_widget_show(combust_l);
	combust = make_frame(NULL, 1);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), combust, combust_l);

	verify_l = gtk_label_new(_("Verify"));
	gtk_widget_show(verify_l);
	verify = make_frame(NULL, 1);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), verify, verify_l);

	create_options(options);
	cdr_info = create_cdrecord_options(burn_options);
	create_filepicker(filepicker, cdr_info);
	mainptr->cdr_option_info = cdr_info;
	create_audio(audio);

	/* since gtk 1.2.5 show must be called on mainwindow before the following
	 * and as I don't want an ugly resize I wait until the last minute...
	 * of course, this #if doesn't help if you compile against a new version
	 * and run it with the old version of gtk */
/* #if GTK_MICRO_VERSION >= 5 */
#if GCOM_USE_OLD_GTK
	gtk_widget_show(mainwindow);
#endif

	create_text_status(combust);
	create_verify(verify);

	mainptr->options = options;
	mainptr->filepicker = filepicker;
	mainptr->audio = audio;
	mainptr->burn_options = burn_options;
	mainptr->notebook = notebook;

	return notebook;
}

void setup_everything(void) {
	GtkWidget *notebook, *vbox;

	tooltips = gtk_tooltips_new();

	vbox = create_window();
	notebook = create_notebook(vbox);

	gtk_signal_handlers_destroy(GTK_OBJECT(mainwindow));
	gtk_signal_connect(GTK_OBJECT(mainwindow), "delete_event",
			GTK_SIGNAL_FUNC(destroy_win), NULL);

/* #if GTK_MICRO_VERSION < 5 */
#if !GCOM_USE_OLD_GTK
	gtk_widget_show(mainwindow);
#endif
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (sc_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
}

